/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import com.flipkart.flux.domain.Status;
import java.sql.Timestamp;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="AuditRecords")
public class AuditRecord {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String stateMachineInstanceId;
    private Long stateId;
    private Long retryAttempt;
    @Enumerated(value=EnumType.STRING)
    private Status stateStatus;
    @Enumerated(value=EnumType.STRING)
    private Status stateRollbackStatus;
    private String errors;
    private Long taskExecutionVersion;
    private String eventDependencies;
    private Timestamp createdAt;

    protected AuditRecord() {
    }

    public AuditRecord(String stateMachineInstanceId, Long stateId, Long retryAttempt, Status stateStatus, Status stateRollbackStatus, String errors) {
        this(stateMachineInstanceId, stateId, retryAttempt, stateStatus, stateRollbackStatus, errors, 0L, "");
    }

    public AuditRecord(String stateMachineInstanceId, Long stateId, Long retryAttempt, Status stateStatus, Status stateRollbackStatus, String errors, Long taskExecutionVersion, String eventDependencies) {
        this.stateMachineInstanceId = stateMachineInstanceId;
        this.stateId = stateId;
        this.retryAttempt = retryAttempt;
        this.stateStatus = stateStatus;
        this.stateRollbackStatus = stateRollbackStatus;
        this.errors = errors;
        this.taskExecutionVersion = taskExecutionVersion;
        this.eventDependencies = eventDependencies;
    }

    public Long getId() {
        return this.id;
    }

    public String getStateMachineInstanceId() {
        return this.stateMachineInstanceId;
    }

    public void setStateMachineInstanceId(String stateMachineInstanceId) {
        this.stateMachineInstanceId = stateMachineInstanceId;
    }

    public Long getStateId() {
        return this.stateId;
    }

    public void setStateId(Long stateId) {
        this.stateId = stateId;
    }

    public Long getRetryAttempt() {
        return this.retryAttempt;
    }

    public void setRetryAttempt(Long retryAttempt) {
        this.retryAttempt = retryAttempt;
    }

    public Status getStateStatus() {
        return this.stateStatus;
    }

    public void setStateStatus(Status stateStatus) {
        this.stateStatus = stateStatus;
    }

    public Status getStateRollbackStatus() {
        return this.stateRollbackStatus;
    }

    public void setStateRollbackStatus(Status stateRollbackStatus) {
        this.stateRollbackStatus = stateRollbackStatus;
    }

    public String getErrors() {
        return this.errors;
    }

    public void setErrors(String errors) {
        this.errors = errors;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public Long getTaskExecutionVersion() {
        return this.taskExecutionVersion;
    }

    public void setTaskExecutionVersion(Long taskExecutionVersion) {
        this.taskExecutionVersion = taskExecutionVersion;
    }

    public String getEventDependencies() {
        return this.eventDependencies;
    }

    public void setEventDependencies(String eventDependencies) {
        this.eventDependencies = eventDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditRecord)) {
            return false;
        }
        AuditRecord that = (AuditRecord)o;
        if (this.retryAttempt != null ? !this.retryAttempt.equals(that.retryAttempt) : that.retryAttempt != null) {
            return false;
        }
        if (this.stateId != null ? !this.stateId.equals(that.stateId) : that.stateId != null) {
            return false;
        }
        if (this.stateMachineInstanceId != null ? !this.stateMachineInstanceId.equals(that.stateMachineInstanceId) : that.stateMachineInstanceId != null) {
            return false;
        }
        if (this.stateRollbackStatus != that.stateRollbackStatus) {
            return false;
        }
        if (this.stateStatus != that.stateStatus) {
            return false;
        }
        if (this.taskExecutionVersion != that.taskExecutionVersion) {
            return false;
        }
        return this.eventDependencies == that.eventDependencies;
    }

    public int hashCode() {
        int result = this.stateMachineInstanceId != null ? this.stateMachineInstanceId.hashCode() : 0;
        result = 31 * result + (this.stateId != null ? this.stateId.hashCode() : 0);
        result = 31 * result + (this.retryAttempt != null ? this.retryAttempt.hashCode() : 0);
        result = 31 * result + (this.stateStatus != null ? this.stateStatus.hashCode() : 0);
        result = 31 * result + (this.stateRollbackStatus != null ? this.stateRollbackStatus.hashCode() : 0);
        result = 31 * result + (this.taskExecutionVersion != null ? this.taskExecutionVersion.hashCode() : 0);
        result = 31 * result + (this.eventDependencies != null ? this.eventDependencies.hashCode() : 0);
        return result;
    }
}

