/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="StateTraversalPaths")
@IdClass(value=StateTraversalPathPK.class)
public class StateTraversalPath {
    @Id
    private Long stateId;
    @Id
    private String stateMachineId;
    @Type(type="LongListJsonType")
    private List<Long> nextDependentStates = new LinkedList<Long>();
    private Timestamp createdAt;

    protected StateTraversalPath() {
    }

    public StateTraversalPath(String stateMachineId, Long stateId, List<Long> nextDependentStates) {
        this();
        this.stateMachineId = stateMachineId;
        this.stateId = stateId;
        this.nextDependentStates = nextDependentStates;
    }

    public Long getStateId() {
        return this.stateId;
    }

    public void setStateId(Long stateId) {
        this.stateId = stateId;
    }

    public String getStateMachineId() {
        return this.stateMachineId;
    }

    public void setStateMachineId(String stateMachineId) {
        this.stateMachineId = stateMachineId;
    }

    public List<Long> getNextDependentStates() {
        return this.nextDependentStates;
    }

    public void setNextDependentStates(List<Long> nextDependentStates) {
        this.nextDependentStates = nextDependentStates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateTraversalPath)) {
            return false;
        }
        StateTraversalPath stateTraversalPath = (StateTraversalPath)o;
        if (this.stateMachineId != null ? !this.stateMachineId.equals(stateTraversalPath.stateMachineId) : stateTraversalPath.stateMachineId != null) {
            return false;
        }
        return !(this.stateId != null ? !this.stateId.equals(stateTraversalPath.stateId) : stateTraversalPath.stateId != null);
    }

    public int hashCode() {
        int result = this.stateMachineId != null ? this.stateMachineId.hashCode() : 0;
        result = 31 * result + (this.stateId != null ? this.stateId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StateTraversalPath{stateId=" + this.stateId + ", stateMachineId=" + this.stateMachineId + ", nextDependentStates=" + this.nextDependentStates + ", createdAt=" + this.createdAt + '}';
    }

    static class StateTraversalPathPK
    implements Serializable {
        private Long stateId;
        private String stateMachineId;

        public StateTraversalPathPK() {
        }

        public StateTraversalPathPK(Long stateId, String stateMachineId) {
            this.stateId = stateId;
            this.stateMachineId = stateMachineId;
        }

        public Long getStateId() {
            return this.stateId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateTraversalPathPK)) {
                return false;
            }
            StateTraversalPathPK stateTraversalPathPK = (StateTraversalPathPK)o;
            if (!this.getStateId().equals(stateTraversalPathPK.getStateId())) {
                return false;
            }
            return this.getStateMachineId().equals(stateTraversalPathPK.getStateMachineId());
        }

        public int hashCode() {
            int result = this.getStateId().hashCode();
            result = 31 * result + this.getStateMachineId().hashCode();
            return result;
        }

        public void setStateId(Long stateId) {
            this.stateId = stateId;
        }

        public String getStateMachineId() {
            return this.stateMachineId;
        }

        public void setStateMachineId(String stateMachineId) {
            this.stateMachineId = stateMachineId;
        }
    }
}

