/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

@Entity
@Table(name="Events")
@IdClass(value=EventPK.class)
public class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private String name;
    private String type;
    @Enumerated(value=EnumType.STRING)
    private EventStatus status;
    @Id
    private String stateMachineInstanceId;
    private String eventData;
    private String eventSource;
    @Id
    private Long executionVersion;
    private Timestamp createdAt;
    @Column(updatable=false)
    private Timestamp updatedAt;

    public Event() {
    }

    public Event(String name, String type, EventStatus status, String stateMachineInstanceId, String eventData, String eventSource) {
        this(name, type, status, stateMachineInstanceId, eventData, eventSource, 0L);
    }

    public Event(String name, String type, EventStatus status, String stateMachineInstanceId, String eventData, String eventSource, Long executionVersion) {
        this.name = name;
        this.type = type;
        this.status = status;
        this.stateMachineInstanceId = stateMachineInstanceId;
        this.eventData = eventData;
        this.eventSource = eventSource;
        this.executionVersion = executionVersion;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventStatus getStatus() {
        return this.status;
    }

    public void setStatus(EventStatus status) {
        this.status = status;
    }

    public String getStateMachineInstanceId() {
        return this.stateMachineInstanceId;
    }

    public void setStateMachineInstanceId(String stateMachineInstanceId) {
        this.stateMachineInstanceId = stateMachineInstanceId;
    }

    public String getEventData() {
        return this.eventData;
    }

    public void setEventData(String eventData) {
        this.eventData = eventData;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public Timestamp getUpdatedAt() {
        return this.updatedAt;
    }

    public Long getExecutionVersion() {
        return this.executionVersion;
    }

    public void setExecutionVersion(Long executionVersion) {
        this.executionVersion = executionVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        if (this.eventData != null ? !this.eventData.equals(event.eventData) : event.eventData != null) {
            return false;
        }
        if (this.eventSource != null ? !this.eventSource.equals(event.eventSource) : event.eventSource != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(event.name) : event.name != null) {
            return false;
        }
        if (this.stateMachineInstanceId != null ? !this.stateMachineInstanceId.equals(event.stateMachineInstanceId) : event.stateMachineInstanceId != null) {
            return false;
        }
        if (this.status != event.status) {
            return false;
        }
        if (this.type != null ? !this.type.equals(event.type) : event.type != null) {
            return false;
        }
        return !(this.executionVersion != null ? !this.executionVersion.equals(event.executionVersion) : event.executionVersion != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.stateMachineInstanceId != null ? this.stateMachineInstanceId.hashCode() : 0);
        result = 31 * result + (this.eventData != null ? this.eventData.hashCode() : 0);
        result = 31 * result + (this.eventSource != null ? this.eventSource.hashCode() : 0);
        result = 31 * result + (this.executionVersion != null ? this.executionVersion.hashCode() : 0);
        return result;
    }

    static class EventPK
    implements Serializable {
        private String stateMachineInstanceId;
        private String name;
        private Long executionVersion;

        public EventPK() {
        }

        public EventPK(String stateMachineInstanceId, String name, Long executionVersion) {
            this.stateMachineInstanceId = stateMachineInstanceId;
            this.name = name;
            this.executionVersion = executionVersion;
        }

        public String getStateMachineInstanceId() {
            return this.stateMachineInstanceId;
        }

        public void setStateMachineInstanceId(String stateMachineInstanceId) {
            this.stateMachineInstanceId = stateMachineInstanceId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Long getExecutionVersion() {
            return this.executionVersion;
        }

        public void setExecutionVersion(Long executionVersion) {
            this.executionVersion = executionVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EventPK)) {
                return false;
            }
            EventPK eventPK = (EventPK)o;
            if (!this.getStateMachineInstanceId().equals(eventPK.getStateMachineInstanceId())) {
                return false;
            }
            if (!this.getExecutionVersion().equals(eventPK.getExecutionVersion())) {
                return false;
            }
            return this.getName().equals(eventPK.getName());
        }

        public int hashCode() {
            int result = this.getStateMachineInstanceId().hashCode();
            result = 31 * result + this.getName().hashCode();
            result = 31 * result + this.getExecutionVersion().hashCode();
            return result;
        }
    }

    public static enum EventStatus {
        pending,
        triggered,
        cancelled,
        invalid;

    }
}

