/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence.dao.impl;

import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.dao.iface.AuditDAOV1;
import com.flipkart.flux.persistence.dao.impl.AbstractDAO;
import com.flipkart.flux.persistence.key.EntityId;
import com.flipkart.flux.persistence.key.FSMId;
import com.google.inject.name.Named;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class AuditDAOV1Impl
extends AbstractDAO<AuditRecord>
implements AuditDAOV1 {
    @Inject
    public AuditDAOV1Impl(@Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    public AuditRecord create(AuditRecord auditRecord) {
        if (auditRecord.getErrors() != null && auditRecord.getErrors().toCharArray().length > 999) {
            auditRecord.setErrors(auditRecord.getErrors().substring(0, 995));
        }
        return super.save(auditRecord);
    }

    public AuditRecord findEntity(Object key) {
        if (!(key instanceof EntityId)) {
            throw new PersistenceException("Find AuditRecord is not supported for key : " + key);
        }
        return (AuditRecord)super.findById(AuditRecord.class, ((EntityId)key).entityId);
    }

    public void remove(AuditRecord entity) {
        throw new PersistenceException("Operation is not supported!");
    }

    public AuditRecord[] findEntities(Object key) {
        if (key instanceof FSMId) {
            return this.findAuditRecordsForFSMId((FSMId)key);
        }
        throw new PersistenceException("Find AuditRecordS is not supported for key : " + key);
    }

    private AuditRecord[] findAuditRecordsForFSMId(FSMId key) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(AuditRecord.class);
        Root root = cq.from(AuditRecord.class);
        cq.select((Selection)root).where((Expression)cb.equal((Expression)root.get("stateMachineInstanceId"), (Object)key.statemachineId));
        return this.currentSession().createQuery(cq).getResultList().toArray(new AuditRecord[0]);
    }
}

