/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence.dao.impl;

import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateMachineStatus;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.impl.AbstractDAO;
import com.flipkart.flux.shard.ShardId;
import com.google.inject.name.Named;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class StateMachinesDAOImpl
extends AbstractDAO<StateMachine>
implements StateMachinesDAO {
    public static final String FOR_UPDATE = "for update";

    @Inject
    public StateMachinesDAOImpl(@Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public StateMachine create(String stateMachineInstanceId, StateMachine stateMachine) {
        return super.save(stateMachine);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public StateMachine findById(String stateMachineInstanceId) {
        return (StateMachine)super.findById(StateMachine.class, stateMachineInstanceId);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_ONLY, storage=Storage.SHARDED)
    public Set<StateMachine> findByName(ShardId shardId, String stateMachineName) {
        Criteria criteria = this.currentSession().createCriteria(StateMachine.class).add((Criterion)Restrictions.eq((String)"name", (Object)stateMachineName));
        List stateMachines = criteria.list();
        return new HashSet<StateMachine>(stateMachines);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_ONLY, storage=Storage.SHARDED)
    public Set<StateMachine> findByNameAndVersion(ShardId shardId, String stateMachineName, Long version) {
        Criteria criteria = this.currentSession().createCriteria(StateMachine.class).add((Criterion)Restrictions.eq((String)"name", (Object)stateMachineName)).add((Criterion)Restrictions.eq((String)"version", (Object)version));
        List stateMachines = criteria.list();
        return new HashSet<StateMachine>(stateMachines);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateStatus(String stateMachineId, StateMachineStatus status) {
        Query query = this.currentSession().createQuery("update StateMachine set status = :status where id = :stateMachineId");
        query.setString("status", status != null ? status.toString() : null);
        query.setString("stateMachineId", stateMachineId);
        query.executeUpdate();
    }

    public Long findExecutionVersionBySMIdForUpdate_NonTransactional(String stateMachineId, Session session) {
        NativeQuery sqlQuery = this.currentSession().createSQLQuery("select executionVersion from StateMachines where id = :stateMachineId for update");
        sqlQuery.setString("stateMachineId", stateMachineId);
        return Long.valueOf(sqlQuery.uniqueResult().toString());
    }

    public void updateExecutionVersion_NonTransactional(String stateMachineId, Long smExecutionVersion, Session session) {
        Query query = session.createQuery("update StateMachine set executionVersion = :executionVersion where id = :stateMachineId");
        query.setLong("executionVersion", smExecutionVersion.longValue());
        query.setString("stateMachineId", stateMachineId);
        query.executeUpdate();
    }
}

