/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence.dao.impl;

import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.criteria.DependentEventCriteria;
import com.flipkart.flux.persistence.criteria.FSMStatusCriteria;
import com.flipkart.flux.persistence.dao.iface.StatesDAOV1;
import com.flipkart.flux.persistence.dao.impl.AbstractDAO;
import com.flipkart.flux.persistence.dto.StateUpdate;
import com.flipkart.flux.persistence.key.EntityId;
import com.flipkart.flux.persistence.key.FSMIdEntityId;
import com.flipkart.flux.persistence.key.FSMIdStateIds;
import com.google.inject.name.Named;
import java.util.Arrays;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.NativeQuery;

public class StatesDAOV1Impl
extends AbstractDAO<State>
implements StatesDAOV1 {
    @Inject
    public StatesDAOV1Impl(@Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    public State create(State state) {
        return super.save(state);
    }

    @Override
    public void update(State object) {
        super.update(object);
    }

    public void remove(State entity) {
        throw new PersistenceException("Operation is not supported!");
    }

    public State findEntity(Object key) {
        if (key instanceof FSMIdEntityId) {
            return this.findByCompositeId((FSMIdEntityId)key);
        }
        if (key instanceof EntityId) {
            return (State)super.findById(State.class, ((EntityId)key).entityId);
        }
        throw new PersistenceException("Find State is not supported for : " + key);
    }

    public State[] findEntities(Object key) {
        if (key instanceof FSMIdStateIds) {
            return this.findStatesForStateIds((FSMIdStateIds)key);
        }
        if (key instanceof FSMStatusCriteria) {
            return this.findStatesByStatusCriteria((FSMStatusCriteria)key);
        }
        if (key instanceof DependentEventCriteria) {
            return this.findStatesByDependentEvent((DependentEventCriteria)key);
        }
        throw new PersistenceException("Find StateS is not supported for key : " + key);
    }

    public void updateState(StateUpdate.Field field, Object updates) {
        switch (field) {
            case status: {
                if (!(updates instanceof StateUpdate.StatusUpdate)) break;
                this.updateStatus((StateUpdate.StatusUpdate)updates);
                return;
            }
            case rollbackStatus: {
                if (!(updates instanceof StateUpdate.RollbackStatusUpdate)) break;
                this.updateRollbackStatus((StateUpdate.RollbackStatusUpdate)updates);
                return;
            }
            case attemptedNoOfRetries: {
                if (!(updates instanceof StateUpdate.NoOfRetriesIncrement)) break;
                this.incrementRetryCount((StateUpdate.NoOfRetriesIncrement)updates);
                return;
            }
            case attemptedNumOfReplayableRetries: {
                if (!(updates instanceof StateUpdate.ReplayableRetriesUpdate)) break;
                this.updateReplayableRetries((StateUpdate.ReplayableRetriesUpdate)updates);
                return;
            }
            case executionVersion: {
                if (!(updates instanceof StateUpdate.ExecutionVersionUpdate)) break;
                this.updateExecutionVersion((StateUpdate.ExecutionVersionUpdate)updates);
                return;
            }
            default: {
                throw new PersistenceException("Unable to update State using unsupported Field type : " + field);
            }
        }
        throw new PersistenceException("Unable to update State using unsupported update object type : " + updates);
    }

    public short getReplayableRetriesForUpdate(FSMIdEntityId fsmIdEntityId) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(State.class);
        Root root = cq.from(State.class);
        Predicate[] restrictions = new Predicate[]{cb.equal((Expression)root.get("stateMachineId"), (Object)fsmIdEntityId.fsmId), cb.equal((Expression)root.get("id"), (Object)fsmIdEntityId.entityId.entityId)};
        cq.select((Selection)root).where(restrictions);
        return ((State)this.currentSession().createQuery(cq).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult()).getAttemptedNumOfReplayableRetries();
    }

    private void updateStatus(StateUpdate.StatusUpdate statusUpdate) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaUpdate cu = cb.createCriteriaUpdate(State.class);
        Root root = cu.from(State.class);
        cu.set("status", (Object)statusUpdate.status);
        Predicate[] restrictions = new Predicate[]{cb.equal((Expression)root.get("stateMachineId"), (Object)statusUpdate.fsmId.statemachineId), cb.in((Expression)root.get("id").in(Arrays.asList(statusUpdate.stateIds)))};
        cu.where(restrictions);
        this.currentSession().createQuery(cu).executeUpdate();
    }

    private void updateRollbackStatus(StateUpdate.RollbackStatusUpdate rollbackStatusUpdate) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaUpdate cu = cb.createCriteriaUpdate(State.class);
        Root root = cu.from(State.class);
        cu.set("rollbackStatus", (Object)rollbackStatusUpdate.status);
        Predicate[] restrictions = new Predicate[]{cb.equal((Expression)root.get("id"), (Object)rollbackStatusUpdate.fsmIdEntityId.entityId.entityId), cb.equal((Expression)root.get("stateMachineId"), (Object)rollbackStatusUpdate.fsmIdEntityId.fsmId.statemachineId)};
        cu.where(restrictions);
        this.currentSession().createQuery(cu).executeUpdate();
    }

    private void incrementRetryCount(StateUpdate.NoOfRetriesIncrement retriesIncrementUpdate) {
        NativeQuery query = this.currentSession().createNativeQuery("update State set attemptedNoOfRetries = attemptedNoOfRetries + 1 where id = :stateId and stateMachineId = :stateMachineId");
        query.setParameter("id", (Object)retriesIncrementUpdate.fsmIdEntityId.entityId.entityId);
        query.setParameter("stateMachineId", (Object)retriesIncrementUpdate.fsmIdEntityId.fsmId.statemachineId);
        query.executeUpdate();
    }

    private void updateReplayableRetries(StateUpdate.ReplayableRetriesUpdate replayableRetriesUpdate) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaUpdate cu = cb.createCriteriaUpdate(State.class);
        Root root = cu.from(State.class);
        cu.set("attemptedNumOfReplayableRetries", (Object)replayableRetriesUpdate.retries);
        Predicate[] restrictions = new Predicate[]{cb.equal((Expression)root.get("id"), (Object)replayableRetriesUpdate.fsmIdEntityId.entityId.entityId), cb.equal((Expression)root.get("stateMachineId"), (Object)replayableRetriesUpdate.fsmIdEntityId.fsmId.statemachineId)};
        cu.where(restrictions);
        this.currentSession().createQuery(cu).executeUpdate();
    }

    private void updateExecutionVersion(StateUpdate.ExecutionVersionUpdate executionVersionUpdate) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaUpdate cu = cb.createCriteriaUpdate(State.class);
        Root root = cu.from(State.class);
        cu.set("executionVersion", (Object)executionVersionUpdate.version);
        Predicate[] restrictions = new Predicate[]{cb.equal((Expression)root.get("id"), (Object)executionVersionUpdate.fsmIdEntityId.entityId.entityId), cb.equal((Expression)root.get("stateMachineId"), (Object)executionVersionUpdate.fsmIdEntityId.fsmId.statemachineId)};
        cu.where(restrictions);
        this.currentSession().createQuery(cu).executeUpdate();
    }

    private State[] findStatesForStateIds(FSMIdStateIds fsmIdStateIds) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(State.class);
        Root root = cq.from(State.class);
        cq.select((Selection)root).where((Expression)cb.in((Expression)root.get("id").in(Arrays.asList(fsmIdStateIds.stateIds))));
        return this.currentSession().createQuery(cq).getResultList().toArray(new State[0]);
    }

    private State findByCompositeId(FSMIdEntityId fsmIdEntityId) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(State.class);
        Root root = cq.from(State.class);
        Predicate[] restrictions = new Predicate[]{cb.equal((Expression)root.get("id"), (Object)fsmIdEntityId.entityId.entityId), cb.equal((Expression)root.get("stateMachineId"), (Object)fsmIdEntityId.fsmId.statemachineId)};
        cq.select((Selection)root).where(restrictions);
        return (State)this.currentSession().createQuery(cq).getSingleResult();
    }

    private State[] findStatesByStatusCriteria(FSMStatusCriteria statusCriteria) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(State.class);
        Root stateRoot = cq.from(State.class);
        Root fsmRoot = cq.from(StateMachine.class);
        cq.multiselect(new Selection[]{stateRoot, fsmRoot});
        LinkedList<Object> predicateList = new LinkedList<Object>();
        predicateList.add(cb.equal((Expression)fsmRoot.get("id"), (Expression)stateRoot.get("stateMachineId")));
        predicateList.add(cb.equal((Expression)fsmRoot.get("name"), (Object)statusCriteria.stateMachineName));
        predicateList.add(cb.between((Expression)fsmRoot.get("createdAt"), (Comparable)statusCriteria.fromTime, (Comparable)statusCriteria.toTime));
        predicateList.add(cb.in((Expression)stateRoot.get("status").in(Arrays.asList(statusCriteria.statuses))));
        if (statusCriteria.stateName != null) {
            predicateList.add(cb.equal((Expression)stateRoot.get("name"), (Object)statusCriteria.stateName));
        }
        cq.where(predicateList.toArray(new Predicate[0]));
        return this.currentSession().createQuery(cq).getResultList().toArray(new State[0]);
    }

    private State[] findStatesByDependentEvent(DependentEventCriteria eventCriteria) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(State.class);
        Root root = cq.from(State.class);
        Predicate[] restrictions = new Predicate[]{cb.equal((Expression)root.get("stateMachineId"), (Object)eventCriteria.fsmId.statemachineId), cb.like((Expression)root.get("dependencies"), "%" + eventCriteria.eventName + "%")};
        cq.select((Selection)root).where(restrictions);
        return this.currentSession().createQuery(cq).getResultList().toArray(new State[0]);
    }
}

