/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence;

import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateMachineStatus;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.EntityManager;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAOV1;
import com.flipkart.flux.persistence.dto.StateMachineUpdate;
import com.flipkart.flux.persistence.key.FSMId;
import javax.inject.Inject;
import javax.transaction.Transactional;

public class StateMachineEntityManager
extends EntityManager<StateMachine> {
    @Inject
    public StateMachineEntityManager(StateMachinesDAOV1 stateMachinesDAOV1) {
        super(stateMachinesDAOV1);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateStatus(FSMId fsmId, StateMachineStatus status) {
        ((StateMachinesDAOV1)this.getDAO()).updateStateMachine(StateMachineUpdate.Field.status, new StateMachineUpdate.StatusUpdate(fsmId, status));
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public long getExecutionVersionForUpdate(FSMId fsmId) {
        return ((StateMachinesDAOV1)this.getDAO()).getExecutionVersionForUpdate(fsmId);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateExecutionVersion(FSMId fsmId, Long smExecutionVersion) {
        ((StateMachinesDAOV1)this.getDAO()).updateStateMachine(StateMachineUpdate.Field.executionVersion, new StateMachineUpdate.ExecutionVersionUpdate(fsmId, smExecutionVersion));
    }
}

