/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence;

import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.EntityManager;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.persistence.criteria.DependentEventCriteria;
import com.flipkart.flux.persistence.criteria.FSMStatusCriteria;
import com.flipkart.flux.persistence.dao.iface.StatesDAOV1;
import com.flipkart.flux.persistence.dto.StateUpdate;
import com.flipkart.flux.persistence.key.EntityId;
import com.flipkart.flux.persistence.key.FSMId;
import com.flipkart.flux.persistence.key.FSMIdEntityId;
import com.flipkart.flux.shard.ShardId;
import java.sql.Timestamp;
import javax.inject.Inject;
import javax.transaction.Transactional;

public class StateEntityManager
extends EntityManager<State> {
    @Inject
    public StateEntityManager(StatesDAOV1 statesDAO) {
        super(statesDAO);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateStatus(FSMId fsmId, Long[] stateIds, Status status) {
        ((StatesDAOV1)this.getDAO()).updateState(StateUpdate.Field.status, new StateUpdate.StatusUpdate(fsmId, stateIds, status));
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateRollbackStatus(FSMId fsmId, Long stateId, Status rollbackStatus) {
        ((StatesDAOV1)this.getDAO()).updateState(StateUpdate.Field.rollbackStatus, new StateUpdate.RollbackStatusUpdate(new FSMIdEntityId(fsmId, new EntityId(stateId)), rollbackStatus));
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void incrementRetryCount(FSMId fsmId, Long stateId) {
        ((StatesDAOV1)this.getDAO()).updateState(StateUpdate.Field.attemptedNoOfRetries, new StateUpdate.NoOfRetriesIncrement(new FSMIdEntityId(fsmId, new EntityId(stateId))));
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateExecutionVersion(FSMId fsmId, Long stateId, Long executionVersion) {
        ((StatesDAOV1)this.getDAO()).updateState(StateUpdate.Field.executionVersion, new StateUpdate.ExecutionVersionUpdate(new FSMIdEntityId(fsmId, new EntityId(stateId)), executionVersion));
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateReplayableRetries(FSMId fsmId, Long stateId, Short replayableRetries) {
        ((StatesDAOV1)this.getDAO()).updateState(StateUpdate.Field.attemptedNumOfReplayableRetries, new StateUpdate.ReplayableRetriesUpdate(new FSMIdEntityId(fsmId, new EntityId(stateId)), replayableRetries));
    }

    public State[] findErroredStates(ShardId shardId, String stateMachineName, Timestamp fromTime, Timestamp toTime) {
        return this.findByFSMStatusCriteria(new FSMStatusCriteria(shardId, stateMachineName, fromTime, toTime, new Status[]{Status.errored}));
    }

    public State[] findStatesByStatus(ShardId shardId, String stateMachineName, Timestamp fromTime, Timestamp toTime, String stateName, Status[] statuses) {
        return this.findByFSMStatusCriteria(new FSMStatusCriteria(shardId, stateMachineName, fromTime, toTime, stateName, statuses));
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_ONLY, storage=Storage.SHARDED)
    public State[] findByFSMStatusCriteria(FSMStatusCriteria fsmStatusCriteria) {
        return (State[])((StatesDAOV1)this.getDAO()).findEntities((Object)fsmStatusCriteria);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_ONLY, storage=Storage.SHARDED)
    public State[] findStatesByDependentEvent(FSMId fsmId, String eventName) {
        return (State[])((StatesDAOV1)this.getDAO()).findEntities((Object)new DependentEventCriteria(fsmId, eventName));
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public short getReplayableRetriesForUpdate(FSMIdEntityId fsmIfdEntityId) {
        return ((StatesDAOV1)this.getDAO()).getReplayableRetriesForUpdate(fsmIfdEntityId);
    }
}

