/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.representation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateDefinition;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.representation.EventPersistenceService;
import com.flipkart.flux.representation.IllegalRepresentationException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StateMachinePersistenceService {
    private StateMachinesDAO stateMachinesDAO;
    private EventPersistenceService eventPersistenceService;
    private final ObjectMapper objectMapper;

    @Inject
    public StateMachinePersistenceService(StateMachinesDAO stateMachinesDAO, EventPersistenceService eventPersistenceService) {
        this.stateMachinesDAO = stateMachinesDAO;
        this.eventPersistenceService = eventPersistenceService;
        this.objectMapper = new ObjectMapper();
    }

    public StateMachine createStateMachine(StateMachineDefinition stateMachineDefinition) {
        Map eventDataMap = stateMachineDefinition.getEventDataMap();
        Set<Event> allEvents = this.createAllEvents(eventDataMap);
        Set stateDefinitions = stateMachineDefinition.getStates();
        HashSet<State> states = new HashSet<State>();
        for (StateDefinition stateDefinition : stateDefinitions) {
            State state = this.convertStateDefinitionToState(stateDefinition);
            states.add(state);
        }
        StateMachine stateMachine = new StateMachine(stateMachineDefinition.getVersion(), stateMachineDefinition.getName(), stateMachineDefinition.getDescription(), states);
        this.stateMachinesDAO.create(stateMachine);
        for (Event event : allEvents) {
            event.setStateMachineInstanceId(stateMachine.getId());
            this.eventPersistenceService.persistEvent(event);
        }
        return stateMachine;
    }

    private Set<Event> createAllEvents(Map<EventDefinition, EventData> eventDataMap) {
        HashSet<Event> allEvents = new HashSet<Event>();
        for (Map.Entry<EventDefinition, EventData> currentEventDefinitionAndData : eventDataMap.entrySet()) {
            Event currentEvent = this.eventPersistenceService.convertEventDefinitionToEvent(currentEventDefinitionAndData.getKey());
            if (currentEventDefinitionAndData.getValue() != null) {
                currentEvent.setEventData(currentEventDefinitionAndData.getValue().getData());
                currentEvent.setEventSource(currentEventDefinitionAndData.getValue().getEventSource());
                currentEvent.setStatus(Event.EventStatus.triggered);
            }
            allEvents.add(currentEvent);
        }
        return allEvents;
    }

    private State convertStateDefinitionToState(StateDefinition stateDefinition) {
        try {
            Set eventDefinitions = stateDefinition.getDependencies();
            HashSet<String> events = new HashSet<String>();
            if (eventDefinitions != null) {
                for (EventDefinition e : eventDefinitions) {
                    events.add(e.getName());
                }
            }
            State state = new State(stateDefinition.getVersion(), stateDefinition.getName(), stateDefinition.getDescription(), stateDefinition.getOnEntryHook(), stateDefinition.getTask(), stateDefinition.getOnExitHook(), events, stateDefinition.getRetryCount(), stateDefinition.getTimeout(), stateDefinition.getOutputEvent() != null ? this.objectMapper.writeValueAsString((Object)stateDefinition.getOutputEvent()) : null);
            return state;
        }
        catch (Exception e) {
            throw new IllegalRepresentationException("Unable to create state domain object", e);
        }
    }
}

