/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.controller.WorkFlowExecutionController;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.representation.IllegalRepresentationException;
import com.flipkart.flux.representation.StateMachinePersistenceService;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/api/machines")
@Named
public class StateMachineResource {
    private static final String TRIGGER = " ";
    @Inject
    StateMachinePersistenceService stateMachinePersistenceService;
    @Inject
    WorkFlowExecutionController workFlowExecutionController;
    @Inject
    StateMachinesDAO stateMachinesDAO;
    @Inject
    EventsDAO eventsDAO;
    private static final Logger logger = LoggerFactory.getLogger(StateMachineResource.class);

    @POST
    @Consumes(value={"application/json"})
    @Transactional
    public Response createStateMachine(StateMachineDefinition stateMachineDefinition) throws Exception {
        if (stateMachineDefinition == null) {
            throw new IllegalRepresentationException("State machine definition is empty");
        }
        StateMachine stateMachine = this.stateMachinePersistenceService.createStateMachine(stateMachineDefinition);
        this.workFlowExecutionController.initAndStart(stateMachine);
        return Response.status((int)Response.Status.CREATED.getStatusCode()).entity((Object)stateMachine.getId()).build();
    }

    @POST
    @Path(value="/{machineId}/context/events")
    public Response submitEvent(@PathParam(value="machineId") Long machineId, EventData eventData) throws Exception {
        Set<State> triggeredStates = this.workFlowExecutionController.postEvent(eventData, machineId);
        return Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)new ObjectMapper().writeValueAsString(triggeredStates)).build();
    }

    @PUT
    @Path(value="/{machineId}/cancel")
    public void cancelExecution(@PathParam(value="machineId") Long machineId) {
    }

    @GET
    @Path(value="/{machineId}/fsmdata")
    public Response getFsmGraphData(@PathParam(value="machineId") Long machineId) throws IOException {
        return Response.status((int)200).entity((Object)this.getGraphData(machineId)).header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"GET, POST, DELETE, PUT").header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Allow-Headers", (Object)"Content-Type, Accept").build();
    }

    private String getGraphData(Long fsmId) throws IOException {
        StateMachine stateMachine = this.stateMachinesDAO.findById(fsmId);
        if (stateMachine != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap<String, String> eventSourceMap = new HashMap<String, String>();
            HashMap fsmDataMap = new HashMap();
            HashSet<String> initialStates = new HashSet<String>();
            HashSet<String> triggeredEvents = new HashSet<String>(this.eventsDAO.findTriggeredEventsNamesBySMId(fsmId));
            for (State state : stateMachine.getStates()) {
                if (state.getOutputEvent() == null) continue;
                EventDefinition eventDefinition = (EventDefinition)objectMapper.readValue(state.getOutputEvent(), EventDefinition.class);
                eventSourceMap.put(this.getEventDisplayName(eventDefinition.getName()), this.getStateDisplayName(state.getName()));
            }
            for (State state : stateMachine.getStates()) {
                String stateDisplayName = this.getStateDisplayName(state.getName());
                if (state.getDependencies() != null && state.getDependencies().size() > 0) {
                    for (String eventName : state.getDependencies()) {
                        if (!triggeredEvents.contains(eventName)) continue;
                        String eventDisplayName = this.getEventDisplayName(eventName);
                        if (fsmDataMap.get(eventSourceMap.get(eventDisplayName)) == null) {
                            fsmDataMap.put(eventSourceMap.get(eventDisplayName), new ArrayList());
                        }
                        if (fsmDataMap.get(stateDisplayName) == null) {
                            fsmDataMap.put(stateDisplayName, new ArrayList());
                        }
                        ((List)fsmDataMap.get(eventSourceMap.get(eventDisplayName))).add(stateDisplayName + ":" + eventDisplayName);
                    }
                    continue;
                }
                initialStates.add(stateDisplayName);
            }
            if (fsmDataMap.size() == 0) {
                for (String stateName : initialStates) {
                    fsmDataMap.put(stateName, null);
                }
            }
            if (fsmDataMap.containsKey(null)) {
                fsmDataMap.put(TRIGGER, fsmDataMap.get(null));
                fsmDataMap.remove(null);
            }
            if (initialStates.size() > 0) {
                if (fsmDataMap.get(TRIGGER) == null) {
                    fsmDataMap.put(TRIGGER, new ArrayList());
                }
                for (String initialState : initialStates) {
                    ((List)fsmDataMap.get(TRIGGER)).add(initialState + ":");
                }
            }
            return objectMapper.writeValueAsString(fsmDataMap);
        }
        return "{}";
    }

    private String getEventDisplayName(String eventName) {
        return eventName == null ? null : this.getDisplayName(eventName.substring(eventName.lastIndexOf(".") + 1));
    }

    private String getStateDisplayName(String stateName) {
        return this.getDisplayName(stateName);
    }

    private String getDisplayName(String label) {
        if (label == null) {
            return null;
        }
        String words = label.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "_");
        StringBuffer sb = new StringBuffer();
        for (String s : words.split("_")) {
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sb.append(s.substring(1, s.length()).toLowerCase());
            sb.append(TRIGGER);
        }
        return sb.toString().trim();
    }
}

