/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.controller;

import akka.actor.ActorRef;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.exception.IllegalEventException;
import com.flipkart.flux.exception.UnknownStateMachine;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WorkFlowExecutionController {
    private StateMachinesDAO stateMachinesDAO;
    private EventsDAO eventsDAO;
    private RouterRegistry routerRegistry;
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowExecutionController.class);

    @Inject
    public WorkFlowExecutionController(EventsDAO eventsDAO, StateMachinesDAO stateMachinesDAO, RouterRegistry routerRegistry) {
        this.eventsDAO = eventsDAO;
        this.stateMachinesDAO = stateMachinesDAO;
        this.routerRegistry = routerRegistry;
    }

    public Set<State> initAndStart(StateMachine stateMachine) {
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        List<String> triggeredEvents = this.eventsDAO.findTriggeredEventsNamesBySMId(stateMachine.getId());
        Set initialStates = context.getInitialStates(new HashSet<String>(triggeredEvents));
        this.executeStates(stateMachine.getId(), initialStates);
        return initialStates;
    }

    public Set<State> postEvent(EventData eventData, Long stateMachineInstanceId, String correlationId) {
        StateMachine stateMachine = null;
        if (stateMachineInstanceId != null) {
            stateMachine = this.retrieveStateMachine(stateMachineInstanceId);
        } else if (correlationId != null) {
            stateMachine = this.retrieveStateMachineByCorrelationId(correlationId);
            Long l = stateMachineInstanceId = stateMachine == null ? null : stateMachine.getId();
        }
        if (stateMachine == null) {
            throw new UnknownStateMachine("State machine with id: " + stateMachineInstanceId + " or correlation id " + correlationId + " not found");
        }
        Event event = this.eventsDAO.findBySMIdAndName(stateMachineInstanceId, eventData.getName());
        if (event == null) {
            throw new IllegalEventException("Event with stateMachineId: " + stateMachineInstanceId + ", event name: " + eventData.getName() + " not found");
        }
        event.setStatus(Event.EventStatus.triggered);
        event.setEventData(eventData.getData());
        event.setEventSource(eventData.getEventSource());
        this.eventsDAO.updateEvent(event);
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        Set dependantStates = context.getDependantStates(eventData.getName());
        logger.debug("These states {} depend on event {}", (Object)dependantStates, (Object)eventData.getName());
        Set<State> executableStates = this.getExecutableStates(dependantStates, stateMachineInstanceId);
        logger.debug("These states {} are now unblocked after event {}", executableStates, (Object)eventData.getName());
        this.executeStates(stateMachineInstanceId, executableStates);
        return executableStates;
    }

    private StateMachine retrieveStateMachineByCorrelationId(String correlationId) {
        return this.stateMachinesDAO.findByCorrelationId(correlationId);
    }

    private void executeStates(Long stateMachineInstanceId, Set<State> executableStates) {
        executableStates.forEach(state -> {
            TaskAndEvents msg = new TaskAndEvents(state.getName(), state.getTask(), this.eventsDAO.findByEventNamesAndSMId(state.getDependencies(), stateMachineInstanceId).toArray(new Event[0]), stateMachineInstanceId, state.getOutputEvent(), state.getRetryCount().longValue());
            logger.debug("Sending msg {} for state machine {}", (Object)msg, (Object)stateMachineInstanceId);
            this.routerRegistry.getRouter("someRouter").tell((Object)msg, ActorRef.noSender());
        });
    }

    private StateMachine retrieveStateMachine(Long stateMachineInstanceId) {
        return this.stateMachinesDAO.findById(stateMachineInstanceId);
    }

    private Set<State> getExecutableStates(Set<State> dependantStates, Long stateMachineInstanceId) {
        HashSet<State> executableStates = new HashSet<State>();
        HashSet<String> receivedEvents = new HashSet<String>(this.eventsDAO.findTriggeredEventsNamesBySMId(stateMachineInstanceId));
        dependantStates.stream().filter(state1 -> state1.isDependencySatisfied(receivedEvents)).forEach(executableStates::add);
        return executableStates;
    }
}

