/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.ExecutionUpdateData;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.controller.WorkFlowExecutionController;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.impl.message.SerializedRedriverTask;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.representation.IllegalRepresentationException;
import com.flipkart.flux.representation.StateMachinePersistenceService;
import com.flipkart.flux.resource.FsmGraph;
import com.flipkart.flux.resource.FsmGraphEdge;
import com.flipkart.flux.resource.FsmGraphVertex;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/api/machines")
@Named
public class StateMachineResource {
    private static final String TRIGGER = " ";
    public static final String CORRELATION_ID = "correlationId";
    StateMachinePersistenceService stateMachinePersistenceService;
    WorkFlowExecutionController workFlowExecutionController;
    StateMachinesDAO stateMachinesDAO;
    StatesDAO statesDAO;
    EventsDAO eventsDAO;
    AuditDAO auditDAO;
    ObjectMapper objectMapper;
    private static final Logger logger = LoggerFactory.getLogger(StateMachineResource.class);

    @Inject
    public StateMachineResource(EventsDAO eventsDAO, StateMachinePersistenceService stateMachinePersistenceService, AuditDAO auditDAO, StateMachinesDAO stateMachinesDAO, StatesDAO statesDAO, WorkFlowExecutionController workFlowExecutionController) {
        this.eventsDAO = eventsDAO;
        this.stateMachinePersistenceService = stateMachinePersistenceService;
        this.stateMachinesDAO = stateMachinesDAO;
        this.statesDAO = statesDAO;
        this.auditDAO = auditDAO;
        this.workFlowExecutionController = workFlowExecutionController;
        this.objectMapper = new ObjectMapper();
    }

    @POST
    @Consumes(value={"application/json"})
    @Transactional
    public Response createStateMachine(StateMachineDefinition stateMachineDefinition) throws Exception {
        if (stateMachineDefinition == null) {
            throw new IllegalRepresentationException("State machine definition is empty");
        }
        StateMachine stateMachine = this.stateMachinePersistenceService.createStateMachine(stateMachineDefinition);
        this.workFlowExecutionController.initAndStart(stateMachine);
        return Response.status((int)Response.Status.CREATED.getStatusCode()).entity((Object)stateMachine.getId()).build();
    }

    @POST
    @Path(value="/{machineId}/context/events")
    public Response submitEvent(@PathParam(value="machineId") String machineId, @QueryParam(value="searchField") String searchField, EventData eventData) throws Exception {
        if (searchField != null) {
            if (!searchField.equals(CORRELATION_ID)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.workFlowExecutionController.postEvent(eventData, null, machineId);
        } else {
            this.workFlowExecutionController.postEvent(eventData, Long.valueOf(machineId), null);
        }
        return Response.status((int)Response.Status.ACCEPTED.getStatusCode()).build();
    }

    @POST
    @Path(value="/{machineId}/{stateId}/status")
    @Transactional
    public Response updateStatus(@PathParam(value="machineId") Long machineId, @PathParam(value="stateId") Long stateId, ExecutionUpdateData executionUpdateData) throws Exception {
        Status updateStatus = null;
        switch (executionUpdateData.getStatus()) {
            case initialized: {
                updateStatus = Status.initialized;
                break;
            }
            case running: {
                updateStatus = Status.running;
                break;
            }
            case completed: {
                updateStatus = Status.completed;
                break;
            }
            case cancelled: {
                updateStatus = Status.cancelled;
                break;
            }
            case errored: {
                updateStatus = Status.errored;
                break;
            }
            case sidelined: {
                updateStatus = Status.sidelined;
            }
        }
        this.workFlowExecutionController.updateExecutionStatus(machineId, stateId, updateStatus, executionUpdateData.getRetrycount(), executionUpdateData.getCurrentRetryCount(), executionUpdateData.getErrorMessage());
        return Response.status((int)Response.Status.ACCEPTED.getStatusCode()).build();
    }

    @POST
    @Path(value="/{machineId}/{stateId}/retries/inc")
    @Transactional
    public Response incrementRetry(@PathParam(value="machineId") Long machineId, @PathParam(value="stateId") Long stateId) throws Exception {
        this.workFlowExecutionController.incrementExecutionRetries(machineId, stateId);
        return Response.status((int)Response.Status.ACCEPTED.getStatusCode()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/redrivertask/{taskId}")
    public Response getSerializedRedriverTaskByTaskId(@PathParam(value="taskId") Long taskId) throws Exception {
        State state = this.statesDAO.findById(taskId);
        TaskAndEvents taskAndEvents = new TaskAndEvents(state.getName(), state.getTask(), state.getId(), this.eventsDAO.findByEventNamesAndSMId(state.getDependencies(), state.getStateMachineId()).toArray(new EventData[0]), state.getStateMachineId(), state.getOutputEvent(), state.getRetryCount().longValue(), state.getAttemptedNoOfRetries().longValue());
        SerializedRedriverTask redriverTask = new SerializedRedriverTask(taskAndEvents, state.getStatus());
        return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)redriverTask).build();
    }

    @PUT
    @Path(value="/{machineId}/cancel")
    public void cancelExecution(@PathParam(value="machineId") Long machineId) {
    }

    @GET
    @Path(value="/{machineId}/fsmdata")
    @Produces(value={"application/json"})
    public Response getFsmGraphData(@PathParam(value="machineId") String machineId) throws IOException {
        return Response.status((int)200).entity((Object)this.getGraphData(machineId)).header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"GET, POST, DELETE, PUT").header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Allow-Headers", (Object)"Content-Type, Accept").build();
    }

    @PUT
    @Path(value="/{stateMachineId}/{stateId}/unsideline")
    @Produces(value={"application/json"})
    @Transactional
    public Response unsidelineState(@PathParam(value="stateMachineId") Long stateMachineId, @PathParam(value="stateId") Long stateId) {
        this.workFlowExecutionController.unsidelineState(stateMachineId, stateId);
        return Response.status((int)Response.Status.ACCEPTED.getStatusCode()).build();
    }

    private FsmGraph getGraphData(String machineId) throws IOException {
        Long fsmId = null;
        try {
            fsmId = Long.valueOf(machineId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StateMachine stateMachine = fsmId != null ? this.stateMachinesDAO.findById(fsmId) : this.stateMachinesDAO.findByCorrelationId(machineId);
        if (stateMachine == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("State machine with Id: " + machineId + " not found")).build());
        }
        FsmGraph fsmGraph = new FsmGraph();
        Map<String, Event> stateMachineEvents = this.eventsDAO.findBySMInstanceId(stateMachine.getId()).stream().collect(Collectors.toMap(Event::getName, event -> event));
        HashSet<String> allOutputEventNames = new HashSet<String>();
        RAMContext ramContext = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        for (State state2 : stateMachine.getStates()) {
            FsmGraphVertex vertex = new FsmGraphVertex(state2.getId(), this.getStateDisplayName(state2.getName()));
            if (state2.getOutputEvent() != null) {
                EventDefinition eventDefinition = (EventDefinition)this.objectMapper.readValue(state2.getOutputEvent(), EventDefinition.class);
                Event outputEvent = stateMachineEvents.get(eventDefinition.getName());
                fsmGraph.addVertex(vertex, new FsmGraphEdge(this.getEventDisplayName(outputEvent.getName()), state2.getStatus().name(), outputEvent.getEventSource()));
                Set dependantStates = ramContext.getDependantStates(outputEvent.getName());
                dependantStates.forEach(aState -> fsmGraph.addOutgoingEdge(vertex, aState.getId()));
                allOutputEventNames.add(outputEvent.getName());
                continue;
            }
            fsmGraph.addVertex(vertex, new FsmGraphEdge(null, state2.getStatus().name(), null));
        }
        Set initialStates = ramContext.getInitialStates(Collections.emptySet());
        if (!initialStates.isEmpty()) {
            FsmGraphEdge initEdge = new FsmGraphEdge(TRIGGER, Event.EventStatus.triggered.name(), TRIGGER);
            initialStates.forEach(state -> initEdge.addOutgoingVertex(state.getId()));
            fsmGraph.addInitStateEdge(initEdge);
        }
        HashSet<String> eventsGivenOnWorkflowTrigger = new HashSet<String>(stateMachineEvents.keySet());
        eventsGivenOnWorkflowTrigger.removeAll(allOutputEventNames);
        eventsGivenOnWorkflowTrigger.forEach(workflowTriggeredEventName -> {
            Event correspondingEvent = (Event)stateMachineEvents.get(workflowTriggeredEventName);
            FsmGraphEdge initEdge = new FsmGraphEdge(this.getEventDisplayName((String)workflowTriggeredEventName), correspondingEvent.getStatus().name(), correspondingEvent.getEventSource());
            Set dependantStates = ramContext.getDependantStates(workflowTriggeredEventName);
            dependantStates.forEach(state -> initEdge.addOutgoingVertex(state.getId()));
            fsmGraph.addInitStateEdge(initEdge);
        });
        fsmGraph.setAuditData(this.auditDAO.findBySMInstanceId(stateMachine.getId()));
        return fsmGraph;
    }

    private String getEventDisplayName(String eventName) {
        return eventName == null ? null : this.getDisplayName(eventName.substring(eventName.lastIndexOf(".") + 1));
    }

    private String getStateDisplayName(String stateName) {
        return this.getDisplayName(stateName);
    }

    private String getDisplayName(String label) {
        if (label == null) {
            return null;
        }
        String words = label.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), TRIGGER);
        StringBuffer sb = new StringBuffer();
        for (String s : words.split(TRIGGER)) {
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sb.append(s.substring(1, s.length()).toLowerCase());
            sb.append(TRIGGER);
        }
        return sb.toString().trim();
    }
}

