/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.api.EventData;
import com.flipkart.flux.dao.AbstractDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.domain.Event;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class EventsDAOImpl
extends AbstractDAO<Event>
implements EventsDAO {
    @Inject
    public EventsDAOImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    @Transactional
    public Event create(Event event) {
        return super.save(event);
    }

    @Override
    @Transactional
    public void updateEvent(Event event) {
        super.update(event);
    }

    @Override
    @Transactional
    public List<Event> findBySMInstanceId(Long stateMachineInstanceId) {
        return this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).list();
    }

    @Override
    @Transactional
    public Event findById(Long id) {
        return (Event)super.findById(Event.class, id);
    }

    @Override
    @Transactional
    public Event findBySMIdAndName(Long stateMachineInstanceId, String eventName) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)"name", (Object)eventName));
        return (Event)criteria.uniqueResult();
    }

    @Override
    @Transactional
    public List<String> findTriggeredEventsNamesBySMId(Long stateMachineInstanceId) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)"status", (Object)Event.EventStatus.triggered)).setProjection((Projection)Projections.property((String)"name"));
        return criteria.list();
    }

    @Override
    @Transactional
    public List<Event> findTriggeredEventsBySMId(Long stateMachineInstanceId) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)"status", (Object)Event.EventStatus.triggered));
        return criteria.list();
    }

    @Override
    @Transactional
    public List<EventData> findByEventNamesAndSMId(Set<String> eventNames, Long stateMachineInstanceId) {
        if (eventNames.isEmpty()) {
            return new ArrayList<EventData>();
        }
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).add(Restrictions.in((String)"name", eventNames));
        List readEvents = criteria.list();
        LinkedList<EventData> readEventsDTOs = new LinkedList<EventData>();
        for (Event event : readEvents) {
            readEventsDTOs.add(new EventData(event.getName(), event.getType(), event.getEventData(), event.getEventSource()));
        }
        return readEventsDTOs;
    }
}

