/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.deploymentunit;

import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.deploymentunit.DeploymentUnitClassLoader;
import com.flipkart.flux.deploymentunit.DeploymentUnitUtil;
import com.flipkart.polyguice.config.YamlConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DirectoryBasedDeploymentUnitUtil
implements DeploymentUnitUtil {
    private static final String CONFIG_FILE = "flux_config.yml";
    private static final String WORKFLOW_CLASSES = "workflowClasses";
    private static final String SLASH = "/";
    private String deploymentUnitsPath;

    public DirectoryBasedDeploymentUnitUtil(String deploymentUnitsPath) {
        this.deploymentUnitsPath = deploymentUnitsPath;
    }

    @Override
    public List<String> getAllDeploymentUnitNames() {
        if (this.deploymentUnitsPath != null) {
            File file = new File(this.deploymentUnitsPath);
            String[] directories = file.list((current, name) -> new File(current, name).isDirectory());
            return Arrays.asList(directories);
        }
        return new ArrayList<String>();
    }

    @Override
    public DeploymentUnitClassLoader getClassLoader(String deploymentUnitName) throws MalformedURLException, FileNotFoundException {
        StringBuilder deploymentUnitFQN = new StringBuilder(this.deploymentUnitsPath);
        if (!this.deploymentUnitsPath.endsWith(SLASH)) {
            deploymentUnitFQN.append(SLASH);
        }
        deploymentUnitFQN.append(deploymentUnitName);
        deploymentUnitFQN.append(SLASH);
        return ClassLoaderProvider.getClassLoader(deploymentUnitFQN.toString());
    }

    @Override
    public Set<Method> getTaskMethods(DeploymentUnitClassLoader classLoader) throws ClassNotFoundException, IOException {
        YamlConfiguration yamlConfiguration = this.getProperties(classLoader);
        List classNames = (List)yamlConfiguration.getProperty(WORKFLOW_CLASSES);
        HashSet<Method> methods = new HashSet<Method>();
        Class<?> taskAnnotationClass = classLoader.loadClass(Task.class.getCanonicalName());
        for (String name : classNames) {
            Class<?> clazz = classLoader.loadClass(name);
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(taskAnnotationClass)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    @Override
    public YamlConfiguration getProperties(DeploymentUnitClassLoader classLoader) throws IOException {
        return new YamlConfiguration(classLoader.getResource(CONFIG_FILE));
    }

    static class ClassLoaderProvider {
        ClassLoaderProvider() {
        }

        public static DeploymentUnitClassLoader getClassLoader(String deploymentUnitFQN) throws MalformedURLException, FileNotFoundException {
            File[] mainJars = new File(deploymentUnitFQN + "main").listFiles();
            File[] libJars = new File(deploymentUnitFQN + "lib").listFiles();
            if (mainJars == null) {
                throw new FileNotFoundException("Unable to build class loader. Required directory " + deploymentUnitFQN + "main is empty.");
            }
            File configFile = new File(deploymentUnitFQN + DirectoryBasedDeploymentUnitUtil.CONFIG_FILE);
            if (!configFile.isFile()) {
                throw new FileNotFoundException("Unable to build class loader. Config file not found");
            }
            URL[] urls = new URL[mainJars.length + (libJars != null ? libJars.length : 0) + 1];
            int urlIndex = 0;
            for (File mainJar : mainJars) {
                if (!mainJar.isFile()) continue;
                urls[urlIndex++] = mainJar.toURI().toURL();
            }
            if (libJars != null) {
                for (File libJar : libJars) {
                    if (!libJar.isFile()) continue;
                    urls[urlIndex++] = libJar.toURI().toURL();
                }
            }
            urls[urlIndex] = new File(deploymentUnitFQN).toURI().toURL();
            return new DeploymentUnitClassLoader(urls, null);
        }
    }
}

