/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.DeploymentUnitClassLoader;
import com.flipkart.flux.deploymentunit.DeploymentUnitUtil;
import com.flipkart.flux.guice.module.DeploymentUnitUtilProvider;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUnitModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentUnitModule.class);

    protected void configure() {
        this.bind(DeploymentUnitUtil.class).toProvider(DeploymentUnitUtilProvider.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    @Named(value="deploymentUnits")
    public Map<String, DeploymentUnit> getAllDeploymentUnits(DeploymentUnitUtil deploymentUnitUtil) throws Exception {
        HashMap<String, DeploymentUnit> deploymentUnits = new HashMap<String, DeploymentUnit>();
        try {
            List<String> deploymentUnitNames = deploymentUnitUtil.getAllDeploymentUnitNames();
            for (String deploymentUnitName : deploymentUnitNames) {
                DeploymentUnitClassLoader deploymentUnitClassLoader = deploymentUnitUtil.getClassLoader(deploymentUnitName);
                Set<Method> taskMethods = deploymentUnitUtil.getTaskMethods(deploymentUnitClassLoader);
                YamlConfiguration configuration = deploymentUnitUtil.getProperties(deploymentUnitClassLoader);
                deploymentUnits.put(deploymentUnitName, new DeploymentUnit(deploymentUnitName, deploymentUnitClassLoader, taskMethods, configuration));
            }
        }
        catch (NullPointerException e) {
            logger.error("No deployment units found at location mentioned in configuration.yml - deploymentUnitsPath key");
        }
        return deploymentUnits;
    }
}

