/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.controller;

import akka.actor.ActorRef;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.exception.IllegalEventException;
import com.flipkart.flux.exception.UnknownStateMachine;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WorkFlowExecutionController {
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowExecutionController.class);
    private StateMachinesDAO stateMachinesDAO;
    private EventsDAO eventsDAO;
    private StatesDAO statesDAO;
    private AuditDAO auditDAO;
    private RouterRegistry routerRegistry;
    private RedriverRegistry redriverRegistry;

    @Inject
    public WorkFlowExecutionController(EventsDAO eventsDAO, StateMachinesDAO stateMachinesDAO, StatesDAO statesDAO, AuditDAO auditDAO, RouterRegistry routerRegistry, RedriverRegistry redriverRegistry) {
        this.eventsDAO = eventsDAO;
        this.stateMachinesDAO = stateMachinesDAO;
        this.statesDAO = statesDAO;
        this.auditDAO = auditDAO;
        this.routerRegistry = routerRegistry;
        this.redriverRegistry = redriverRegistry;
    }

    public Set<State> initAndStart(StateMachine stateMachine) {
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        List<String> triggeredEvents = this.eventsDAO.findTriggeredEventsNamesBySMId(stateMachine.getId());
        Set initialStates = context.getInitialStates(new HashSet<String>(triggeredEvents));
        this.executeStates(stateMachine.getId(), initialStates);
        return initialStates;
    }

    public Set<State> postEvent(EventData eventData, Long stateMachineInstanceId, String correlationId) {
        StateMachine stateMachine = null;
        if (stateMachineInstanceId != null) {
            stateMachine = this.retrieveStateMachine(stateMachineInstanceId);
        } else if (correlationId != null) {
            stateMachine = this.retrieveStateMachineByCorrelationId(correlationId);
            Long l = stateMachineInstanceId = stateMachine == null ? null : stateMachine.getId();
        }
        if (stateMachine == null) {
            throw new UnknownStateMachine("State machine with id: " + stateMachineInstanceId + " or correlation id " + correlationId + " not found");
        }
        Event event = this.eventsDAO.findBySMIdAndName(stateMachineInstanceId, eventData.getName());
        if (event == null) {
            throw new IllegalEventException("Event with stateMachineId: " + stateMachineInstanceId + ", event name: " + eventData.getName() + " not found");
        }
        event.setStatus(Event.EventStatus.triggered);
        event.setEventData(eventData.getData());
        event.setEventSource(eventData.getEventSource());
        this.eventsDAO.updateEvent(event);
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        Set dependantStates = context.getDependantStates(eventData.getName());
        logger.debug("These states {} depend on event {}", (Object)dependantStates, (Object)eventData.getName());
        Set<State> executableStates = this.getExecutableStates(dependantStates, stateMachineInstanceId);
        logger.debug("These states {} are now unblocked after event {}", executableStates, (Object)eventData.getName());
        this.executeStates(stateMachineInstanceId, executableStates);
        return executableStates;
    }

    public void updateExecutionStatus(Long stateMachineId, Long taskId, Status status, long retryCount, long currentRetryCount, String errorMessage) {
        this.statesDAO.updateStatus(taskId, stateMachineId, status);
        this.auditDAO.create(new AuditRecord(stateMachineId, taskId, Long.valueOf(currentRetryCount), status, null, errorMessage));
        if (status.equals((Object)Status.completed) && retryCount > 0L) {
            this.redriverRegistry.deRegisterTask(taskId);
        }
    }

    public void unsidelineState(Long stateMachineId, Long stateId) {
        State state = this.statesDAO.findById(stateId);
        if (state.getStatus() == Status.sidelined) {
            state.setStatus(Status.unsidelined);
            state.setAttemptedNoOfRetries(Long.valueOf(0L));
            this.statesDAO.updateState(state);
            this.executeStates(stateMachineId, Sets.newHashSet(Arrays.asList(state)));
        }
    }

    public void incrementExecutionRetries(Long stateMachineId, Long taskId) {
        this.statesDAO.incrementRetryCount(taskId, stateMachineId);
    }

    private StateMachine retrieveStateMachineByCorrelationId(String correlationId) {
        return this.stateMachinesDAO.findByCorrelationId(correlationId);
    }

    private void executeStates(Long stateMachineInstanceId, Set<State> executableStates) {
        executableStates.forEach(state -> {
            int secondUnderscorePosition;
            String taskName;
            TaskAndEvents msg = new TaskAndEvents(state.getName(), state.getTask(), state.getId(), this.eventsDAO.findByEventNamesAndSMId(state.getDependencies(), stateMachineInstanceId).toArray(new EventData[0]), stateMachineInstanceId, state.getOutputEvent(), state.getRetryCount().longValue());
            if (state.getRetryCount() > 0L) {
                long redriverInterval = 2L * state.getRetryCount() * (1000L + state.getTimeout());
                this.redriverRegistry.registerTask(state.getId(), redriverInterval);
            }
            String routerName = taskName.substring(0, (secondUnderscorePosition = (taskName = state.getTask()).indexOf(95, taskName.indexOf(95) + 1)) == -1 ? taskName.length() : secondUnderscorePosition);
            ActorRef router = this.routerRegistry.getRouter(routerName);
            logger.info("Sending msg to router: {} to execute state machine: {} task: {}", new Object[]{router.path(), stateMachineInstanceId, msg.getTaskId()});
            router.tell((Object)msg, ActorRef.noSender());
        });
    }

    private StateMachine retrieveStateMachine(Long stateMachineInstanceId) {
        return this.stateMachinesDAO.findById(stateMachineInstanceId);
    }

    private Set<State> getExecutableStates(Set<State> dependantStates, Long stateMachineInstanceId) {
        HashSet<State> executableStates = new HashSet<State>();
        HashSet<String> receivedEvents = new HashSet<String>(this.eventsDAO.findTriggeredEventsNamesBySMId(stateMachineInstanceId));
        dependantStates.stream().filter(state1 -> state1.isDependencySatisfied(receivedEvents)).forEach(executableStates::add);
        return executableStates;
    }

    public void redriveTask(Long taskId) {
        State state = this.statesDAO.findById(taskId);
        if (this.isTaskRedrivable(state.getStatus()) && state.getAttemptedNoOfRetries() < state.getRetryCount()) {
            logger.info("Redriving a task with Id: {} for state machine: {}", (Object)state.getId(), (Object)state.getStateMachineId());
            this.executeStates(state.getStateMachineId(), Collections.singleton(state));
        }
    }

    private boolean isTaskRedrivable(Status taskStatus) {
        return !taskStatus.equals((Object)Status.completed) && !taskStatus.equals((Object)Status.sidelined) && !taskStatus.equals((Object)Status.errored) && !taskStatus.equals((Object)Status.cancelled);
    }
}

