/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.deploymentunit;

import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.deploymentunit.ClassLoaderInjector;
import com.flipkart.flux.deploymentunit.DeploymentUnitClassLoader;
import com.flipkart.polyguice.config.YamlConfiguration;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class DeploymentUnit {
    private String name;
    private DeploymentUnitClassLoader deploymentUnitClassLoader;
    private Set<Method> taskMethods;
    private Object objectMapperInstance;
    private Object injectorClassInstance;
    private YamlConfiguration configuration;

    public DeploymentUnit(String name, DeploymentUnitClassLoader deploymentUnitClassLoader, Set<Method> taskMethods, YamlConfiguration configuration) {
        this.name = name;
        this.deploymentUnitClassLoader = deploymentUnitClassLoader;
        this.taskMethods = taskMethods;
        this.configuration = configuration;
        this.loadClassLoaderInjector();
        this.createObjectMapperInstance();
    }

    private void loadClassLoaderInjector() {
        try {
            byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/com/flipkart/flux/deploymentunit/ClassLoaderInjector.class"));
            Class injectorClass = this.deploymentUnitClassLoader.defineClass(ClassLoaderInjector.class.getCanonicalName(), classBytes);
            Class<?> guiceModuleClass = this.deploymentUnitClassLoader.loadClass("com.google.inject.Module");
            String DUModuleClassFQN = String.valueOf(this.configuration.getProperty("guiceModuleClass"));
            this.injectorClassInstance = DUModuleClassFQN == null || DUModuleClassFQN.trim().isEmpty() || DUModuleClassFQN.equals("null") ? injectorClass.newInstance() : injectorClass.getConstructor(guiceModuleClass).newInstance(this.deploymentUnitClassLoader.loadClass(DUModuleClassFQN).newInstance());
        }
        catch (Exception e) {
            throw new FluxError(FluxError.ErrorType.runtime, "Unable to load class ClassLoaderInjector into deployment unit's class loader.", (Throwable)e);
        }
    }

    private void createObjectMapperInstance() {
        try {
            Method getInstanceMethod = this.injectorClassInstance.getClass().getMethod("getInstance", Class.class);
            Class<?> objectMapper = this.deploymentUnitClassLoader.loadClass("com.fasterxml.jackson.databind.ObjectMapper");
            this.objectMapperInstance = getInstanceMethod.invoke(this.injectorClassInstance, objectMapper);
        }
        catch (Exception e) {
            throw new FluxError(FluxError.ErrorType.runtime, "Error occurred while creating Object Mapper instance for Deployment Unit: " + this.name, (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public DeploymentUnitClassLoader getDeploymentUnitClassLoader() {
        return this.deploymentUnitClassLoader;
    }

    public Set<Method> getTaskMethods() {
        return this.taskMethods;
    }

    public Object getObjectMapperInstance() {
        return this.objectMapperInstance;
    }

    public Object getInjectorClassInstance() {
        return this.injectorClassInstance;
    }
}

