/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration.Configuration;

public class AkkaModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    @Named(value="routerConfigMap")
    public Map<String, Integer> getRouterConfigs(@Named(value="deploymentUnits") Map<String, DeploymentUnit> deploymentUnitsMap, @Named(value="routers.default.instancesPerNode") int defaultNoOfActors) {
        ConcurrentHashMap<String, Integer> routerConfigMap = new ConcurrentHashMap<String, Integer>();
        for (Map.Entry<String, DeploymentUnit> deploymentUnitEntry : deploymentUnitsMap.entrySet()) {
            DeploymentUnit deploymentUnit = deploymentUnitEntry.getValue();
            Set<Method> taskMethods = deploymentUnit.getTaskMethods();
            Configuration taskConfiguration = deploymentUnit.getTaskConfiguration();
            for (Method taskMethod : taskMethods) {
                String routerName = new MethodId(taskMethod).getPrefix();
                Integer taskExecConcurrency = Optional.ofNullable((Integer)taskConfiguration.getProperty(routerName + ".executionConcurrency")).orElse(defaultNoOfActors);
                routerConfigMap.put(routerName, taskExecConcurrency);
            }
        }
        return routerConfigMap;
    }
}

