/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.flux.dao.AuditDAOImpl;
import com.flipkart.flux.dao.EventsDAOImpl;
import com.flipkart.flux.dao.StateMachinesDAOImpl;
import com.flipkart.flux.dao.StatesDAOImpl;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.guice.interceptor.TransactionInterceptor;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.impl.SessionFactoryContextImpl;
import com.flipkart.flux.redriver.dao.MessageDao;
import com.flipkart.flux.type.BlobType;
import com.flipkart.flux.type.ListJsonType;
import com.flipkart.flux.type.StoreFQNType;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.transaction.Transactional;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.configuration.Configuration;
import org.hibernate.SessionFactory;
import org.hibernate.usertype.UserType;

public class HibernateModule
extends AbstractModule {
    public static final String FLUX_HIBERNATE_CONFIG_NAME_SPACE = "flux.Hibernate";
    public static final String FLUX_READ_ONLY_HIBERNATE_CONFIG_NAME_SPACE = "fluxReadOnly.Hibernate";

    protected void configure() {
        this.bind(AuditDAO.class).to(AuditDAOImpl.class).in(Singleton.class);
        this.bind(EventsDAO.class).to(EventsDAOImpl.class).in(Singleton.class);
        this.bind(StateMachinesDAO.class).to(StateMachinesDAOImpl.class).in(Singleton.class);
        this.bind(StatesDAO.class).to(StatesDAOImpl.class).in(Singleton.class);
        Provider provider = this.getProvider(Key.get(SessionFactoryContext.class, (Annotation)Names.named((String)"fluxSessionFactoryContext")));
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor((javax.inject.Provider)provider);
        this.bindInterceptor(Matchers.not((Matcher)Matchers.inPackage((Package)MessageDao.class.getPackage())), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{transactionInterceptor});
    }

    @Provides
    @Singleton
    @Named(value="fluxHibernateConfiguration")
    public org.hibernate.cfg.Configuration getConfiguration(YamlConfiguration yamlConfiguration) {
        return this.getConfiguration(yamlConfiguration, FLUX_HIBERNATE_CONFIG_NAME_SPACE);
    }

    @Provides
    @Singleton
    @Named(value="fluxReadOnlyHibernateConfiguration")
    public org.hibernate.cfg.Configuration getReadOnlyConfiguration(YamlConfiguration yamlConfiguration) {
        return this.getConfiguration(yamlConfiguration, FLUX_READ_ONLY_HIBERNATE_CONFIG_NAME_SPACE);
    }

    @Provides
    @Singleton
    @Named(value="fluxSessionFactoryContext")
    public SessionFactoryContext getSessionFactoryProvider(@Named(value="fluxHibernateConfiguration") org.hibernate.cfg.Configuration configuration, @Named(value="fluxReadOnlyHibernateConfiguration") org.hibernate.cfg.Configuration readOnlyConfiguration) {
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        SessionFactory readOnlysessionFactory = readOnlyConfiguration.buildSessionFactory();
        HashMap<DataSourceType, SessionFactory> map = new HashMap<DataSourceType, SessionFactory>();
        map.put(DataSourceType.READ_WRITE, sessionFactory);
        map.put(DataSourceType.READ_ONLY, readOnlysessionFactory);
        return new SessionFactoryContextImpl(map, DataSourceType.READ_WRITE);
    }

    private void addAnnotatedClassesAndTypes(org.hibernate.cfg.Configuration configuration) {
        configuration.registerTypeOverride((UserType)new BlobType(), new String[]{"BlobType"});
        configuration.registerTypeOverride((UserType)new StoreFQNType(), new String[]{"StoreFQNOnly"});
        configuration.registerTypeOverride((UserType)new ListJsonType(), new String[]{"ListJsonType"});
        configuration.addAnnotatedClass(AuditRecord.class);
        configuration.addAnnotatedClass(Event.class);
        configuration.addAnnotatedClass(State.class);
        configuration.addAnnotatedClass(StateMachine.class);
    }

    private org.hibernate.cfg.Configuration getConfiguration(YamlConfiguration yamlConfiguration, String prefix) {
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        this.addAnnotatedClassesAndTypes(configuration);
        Configuration hibernateConfig = yamlConfiguration.subset(prefix);
        Iterator propertyKeys = hibernateConfig.getKeys();
        Properties configProperties = new Properties();
        while (propertyKeys.hasNext()) {
            String propertyKey = (String)propertyKeys.next();
            Object propertyValue = hibernateConfig.getProperty(propertyKey);
            configProperties.put(propertyKey, propertyValue);
        }
        configuration.addProperties(configProperties);
        return configuration;
    }
}

