/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.config.TaskRouterUtil;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.iface.DeploymentUnitsManager;
import com.flipkart.flux.exception.DuplicateDeploymentUnitException;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/deployment")
@Named
@Singleton
public class DeploymentUnitResource {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentUnitResource.class);
    private DeploymentUnitsManager deploymentUnitManager;
    private RouterRegistry routerRegistry;
    private TaskRouterUtil taskRouterUtil;

    @Inject
    public DeploymentUnitResource(DeploymentUnitsManager deploymentUnitsManager, RouterRegistry routerRegistry, TaskRouterUtil taskRouterUtil) {
        this.deploymentUnitManager = deploymentUnitsManager;
        this.routerRegistry = routerRegistry;
        this.taskRouterUtil = taskRouterUtil;
    }

    @POST
    @Path(value="/load")
    @Produces(value={"application/json"})
    public Response loadDeploymentUnit(@QueryParam(value="name") String name, @QueryParam(value="version") Integer version, @QueryParam(value="replace") @DefaultValue(value="false") Boolean replaceOld) {
        DeploymentUnit loadedUnit;
        if (name == null || name.length() == 0 || version == null || version < 0) {
            throw new WebApplicationException(this.buildResponse(Response.Status.BAD_REQUEST, "deploymentUnit name or version is invalid"));
        }
        try {
            loadedUnit = this.deploymentUnitManager.load(name, version);
            logger.info("Successfully loaded deploymentUnit: " + loadedUnit.getName() + "/" + loadedUnit.getVersion());
        }
        catch (DuplicateDeploymentUnitException e) {
            logger.error("Received request to load Deployment unit with name: " + name + " and version: " + version + ", which is already loaded. Discarding it.");
            return this.buildResponse(Response.Status.CONFLICT, e.getMessage());
        }
        catch (Exception e) {
            String errMsg = "Could not load deploymentUnit: " + name + "/" + version;
            logger.error(errMsg, (Throwable)e);
            return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, errMsg, e);
        }
        loadedUnit.getTaskMethods().values().stream().forEach(m -> {
            String routerName = new MethodId(m).getPrefix();
            this.routerRegistry.createOrResize(routerName, this.taskRouterUtil.getConcurrency(loadedUnit, routerName).intValue());
        });
        if (replaceOld.booleanValue()) {
            logger.info("Unloading redundant deploymentUnits");
            for (DeploymentUnit unit : this.getRedundantUnits(loadedUnit)) {
                logger.info("Unloading deploymentUnit: " + unit.getName() + "/" + unit.getVersion());
                this.deploymentUnitManager.unload(unit.getName(), unit.getVersion());
            }
        }
        return this.buildResponse(Response.Status.OK, "Successfully loaded deploymentUnit: " + name + "/" + loadedUnit.getVersion());
    }

    @POST
    @Path(value="/unload")
    @Produces(value={"application/json"})
    public Response unloadDeploymentUnit(@QueryParam(value="name") String name, @QueryParam(value="version") Integer version) {
        if (name == null || name.length() == 0 || version == null || version < 0) {
            throw new WebApplicationException(this.buildResponse(Response.Status.BAD_REQUEST, "deploymentUnit name or version is invalid"));
        }
        DeploymentUnit unitToDelete = this.deploymentUnitManager.getAllDeploymentUnits().stream().filter(d -> d.getName().equals(name) && d.getVersion() == version).findFirst().orElse(null);
        if (unitToDelete == null) {
            throw new WebApplicationException(this.buildResponse(Response.Status.NOT_FOUND, "deploymentUnit not found"));
        }
        this.deploymentUnitManager.unload(name, version);
        Set<String> routersToDelete = this.taskRouterUtil.getRouterNames(unitToDelete);
        Set routersInUse = this.deploymentUnitManager.getAllDeploymentUnits().stream().filter(d -> d.getName().equals(name) && d.getVersion() != version).map(d -> this.taskRouterUtil.getRouterNames((DeploymentUnit)d)).flatMap(Collection::stream).distinct().collect(Collectors.toSet());
        routersToDelete.removeAll(routersInUse);
        for (String routerName : routersToDelete) {
            this.routerRegistry.createOrResize(routerName, 0);
        }
        return this.buildResponse(Response.Status.OK, "successfully unloaded deploymentUnit: " + name + "/" + version);
    }

    private List<DeploymentUnit> getRedundantUnits(DeploymentUnit loadedUnit) {
        int loadedVersion = loadedUnit.getVersion();
        Set<String> tasksNames = loadedUnit.getTaskMethods().keySet();
        List olderUnits = this.deploymentUnitManager.getAllDeploymentUnits().stream().filter(d -> d.getName().equals(loadedUnit.getName()) && d.getVersion() < loadedVersion).collect(Collectors.toList());
        return olderUnits.stream().filter(o -> tasksNames.containsAll(o.getTaskMethods().keySet())).collect(Collectors.toList());
    }

    private Response buildResponse(Response.Status status, String msg) {
        return this.buildResponse(status, msg, null);
    }

    private Response buildResponse(Response.Status status, String msg, Throwable e) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("msg", msg);
        if (e != null) {
            response.put("error", e.getMessage());
        }
        return Response.status((Response.Status)status).entity(response).build();
    }
}

