/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.deploymentunit;

import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.deploymentunit.ClassLoaderInjector;
import com.flipkart.flux.deploymentunit.DeploymentUnitClassLoader;
import com.flipkart.polyguice.config.YamlConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUnit {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentUnit.class);
    private static final String WORKFLOW_CLASSES = "workflowClasses";
    private String name;
    private Integer version;
    private DeploymentUnitClassLoader deploymentUnitClassLoader;
    private Map<String, Method> taskMethods;
    private Object objectMapperInstance;
    private Object injectorClassInstance;
    private Object stoppableInstance;
    private YamlConfiguration configuration;

    public DeploymentUnit(String name, Integer version, DeploymentUnitClassLoader deploymentUnitClassLoader, YamlConfiguration configuration) {
        this.name = name;
        this.version = version;
        this.deploymentUnitClassLoader = deploymentUnitClassLoader;
        this.configuration = configuration;
        this.taskMethods = new HashMap<String, Method>();
        this.populateTaskMethods();
        this.loadClassLoaderInjector();
        this.createObjectMapperInstance();
        this.loadStoppableInstance();
    }

    public void close() {
        if (this.stoppableInstance != null) {
            try {
                Method stopMethod = this.stoppableInstance.getClass().getMethod("stop", new Class[0]);
                stopMethod.invoke(this.stoppableInstance, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                LOGGER.error("Unexpected error while calling stop method for deploymentUnit: {}/{}", (Object)this.name, (Object)this.version);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Exception occurred when stop method called for deploymentUnit: {}/{}", new Object[]{this.name, this.version, e});
            }
        }
        try {
            this.deploymentUnitClassLoader.close();
        }
        catch (IOException e) {
            LOGGER.error("IOexception while closing classLoader", (Throwable)e);
        }
    }

    private void loadClassLoaderInjector() {
        Class injectorClass = null;
        try {
            byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/com/flipkart/flux/deploymentunit/ClassLoaderInjector.class"));
            injectorClass = this.deploymentUnitClassLoader.defineClass(ClassLoaderInjector.class.getCanonicalName(), classBytes);
        }
        catch (LinkageError le) {
            LOGGER.error("End of the world! Seems ClassloaderInjector.class is loaded already in this deployment.", (Throwable)le);
            try {
                injectorClass = this.deploymentUnitClassLoader.loadClass("com.flipkart.flux.deploymentunit.ClassLoaderInjector");
            }
            catch (ClassNotFoundException e) {
                throw new FluxError(FluxError.ErrorType.runtime, "Unable to load class ClassLoaderInjector into deployment unit's class loader.", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new FluxError(FluxError.ErrorType.runtime, "Unexpected error while converting ClassLoaderInjector.class to bytes.", (Throwable)e);
        }
        try {
            Class<?> guiceModuleClass = this.deploymentUnitClassLoader.loadClass("com.google.inject.Module");
            String DUModuleClassFQN = String.valueOf(this.configuration.getProperty("guiceModuleClass"));
            this.injectorClassInstance = DUModuleClassFQN == null || DUModuleClassFQN.trim().isEmpty() || DUModuleClassFQN.equals("null") ? injectorClass.newInstance() : injectorClass.getConstructor(guiceModuleClass).newInstance(this.deploymentUnitClassLoader.loadClass(DUModuleClassFQN).newInstance());
        }
        catch (Exception e) {
            throw new FluxError(FluxError.ErrorType.runtime, "Unable to load class ClassLoaderInjector into deployment unit's class loader.", (Throwable)e);
        }
    }

    private void createObjectMapperInstance() {
        this.stoppableInstance = null;
        try {
            Method getInstanceMethod = this.injectorClassInstance.getClass().getMethod("getInstance", Class.class);
            Class<?> objectMapper = this.deploymentUnitClassLoader.loadClass("com.fasterxml.jackson.databind.ObjectMapper");
            this.objectMapperInstance = getInstanceMethod.invoke(this.injectorClassInstance, objectMapper);
        }
        catch (Exception e) {
            throw new FluxError(FluxError.ErrorType.runtime, "Error occurred while creating Object Mapper instance for Deployment Unit: " + this.name + "/" + this.version, (Throwable)e);
        }
    }

    private void loadStoppableInstance() {
        try {
            Method getInstanceMethod = this.injectorClassInstance.getClass().getMethod("getInstance", Class.class);
            Class<?> stoppableClass = this.deploymentUnitClassLoader.loadClass("com.flipkart.flux.client.runtime.Stoppable");
            this.stoppableInstance = getInstanceMethod.invoke(this.injectorClassInstance, stoppableClass);
        }
        catch (Exception e) {
            LOGGER.error("Unable to find/load Stoppable instance for deploymentUnit: {}/{}", new Object[]{this.name, this.version, e});
        }
    }

    private void populateTaskMethods() {
        List classNames = (List)this.configuration.getProperty(WORKFLOW_CLASSES);
        try {
            Class<?> taskAnnotationClass = this.deploymentUnitClassLoader.loadClass(Task.class.getCanonicalName());
            for (String name : classNames) {
                Class<?> clazz = this.deploymentUnitClassLoader.loadClass(name);
                for (Method method : clazz.getMethods()) {
                    if (!method.isAnnotationPresent(taskAnnotationClass)) continue;
                    Annotation taskAnnotation = method.getAnnotationsByType(taskAnnotationClass)[0];
                    long version = 0L;
                    for (Method annotationMethod : taskAnnotationClass.getDeclaredMethods()) {
                        if (!annotationMethod.getName().equals("version")) continue;
                        version = (Long)annotationMethod.invoke((Object)taskAnnotation, new Object[0]);
                    }
                    MethodId methodId = new MethodId(method);
                    String taskIdentifier = methodId.toString() + "_version" + version;
                    this.taskMethods.put(taskIdentifier, method);
                }
            }
        }
        catch (Exception e) {
            throw new FluxError(FluxError.ErrorType.runtime, "Error while getting task methods for deploymentUnit: " + this.name + "/" + this.version, (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public DeploymentUnitClassLoader getDeploymentUnitClassLoader() {
        return this.deploymentUnitClassLoader;
    }

    public Map<String, Method> getTaskMethods() {
        return this.taskMethods;
    }

    public Object getObjectMapperInstance() {
        return this.objectMapperInstance;
    }

    public Object getInjectorClassInstance() {
        return this.injectorClassInstance;
    }

    public Configuration getTaskConfiguration() {
        return this.configuration.subset("taskConfig");
    }

    public Integer getVersion() {
        return this.version;
    }
}

