/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.integration;

import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.model.Workflow;
import com.flipkart.flux.integration.IntegerEvent;
import com.flipkart.flux.integration.StringEvent;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class SimpleWorkflow {
    private static final Logger logger = LogManager.getLogger(SimpleWorkflow.class);

    @Workflow(version=1L)
    public void simpleDummyWorkflow(StringEvent startingEvent) {
        StringEvent newString = this.simpleStringReturningTask(startingEvent);
        IntegerEvent someNewInteger = this.simpleIntegerReturningTask();
        this.someTaskWithIntegerAndString(newString, someNewInteger);
    }

    @Task(version=1L, retries=2L, timeout=2000L)
    public StringEvent simpleStringReturningTask(StringEvent stringEvent) {
        logger.info("In Simple  String returning task {}, received", (Object)stringEvent);
        return new StringEvent("randomString");
    }

    @Task(version=1L, retries=2L, timeout=3000L)
    public IntegerEvent simpleIntegerReturningTask() {
        logger.info("In Simple Integer returning task");
        return new IntegerEvent(2);
    }

    @Task(version=1L, retries=2L, timeout=1000L)
    public void someTaskWithIntegerAndString(StringEvent someString, IntegerEvent someInteger) {
        logger.info("In someTaskWithIntegerAndString with integer {} and string {}", (Object)someInteger, (Object)someString);
    }
}

