/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.representation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.representation.EventPersistenceService;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EventPersistenceServiceTest {
    @Mock
    ObjectMapper objectMapper;
    @Mock
    EventPersistenceService eventPersistenceService;
    @Mock
    EventsDAO eventsDAO;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.objectMapper = new ObjectMapper();
        this.eventPersistenceService = new EventPersistenceService(this.eventsDAO);
    }

    @Test
    public void testConvertEventDefinitionToEvent() throws Exception {
        String eventDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_definition_with_eventSource.json"), (String)"UTF-8");
        EventDefinition eventDefinition = (EventDefinition)this.objectMapper.readValue(eventDefinitionJson, EventDefinition.class);
        Event event = this.eventPersistenceService.convertEventDefinitionToEvent(eventDefinition);
        Assertions.assertThat((String)event.getEventSource()).isNotNull();
    }

    @Test
    public void testConvertEventDefinitionToEventNoEventSource() throws Exception {
        String eventDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_definition_without_eventSource.json"), (String)"UTF-8");
        EventDefinition eventDefinition = (EventDefinition)this.objectMapper.readValue(eventDefinitionJson, EventDefinition.class);
        Event event = this.eventPersistenceService.convertEventDefinitionToEvent(eventDefinition);
        Assertions.assertThat((String)event.getEventSource()).isNull();
    }
}

