/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.api.VersionedEventData;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.integration.StringEvent;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.rule.DbClearWithTestSMRule;
import com.flipkart.flux.runner.GuiceJunit4Runner;
import com.flipkart.flux.runner.Modules;
import com.flipkart.flux.util.TestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GuiceJunit4Runner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, OrchestrationTaskModule.class, FluxClientInterceptorModule.class})
public class EventsDAOTest {
    @InjectFromRole
    private EventsDAO eventsDAO;
    @InjectFromRole
    @Rule
    public DbClearWithTestSMRule dbClearWithTestSMRule;
    @InjectFromRole
    private StateMachinesDAO stateMachinesDAO;
    private ObjectMapper objectMapper;

    @Before
    public void setup() {
        this.objectMapper = new ObjectMapper();
    }

    @Test
    public void createEventTest() throws JsonProcessingException {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        StringEvent data = new StringEvent("event_dat");
        Event event = new Event("test_event_name", "Internal", Event.EventStatus.pending, stateMachine.getId(), this.objectMapper.writeValueAsString((Object)data), "state1");
        this.eventsDAO.create(event.getStateMachineInstanceId(), event);
        Event event1 = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName(event.getStateMachineInstanceId(), event.getName(), Long.valueOf(0L));
        Assertions.assertThat((Object)event1).isEqualTo((Object)event);
    }

    @Test
    public void testRetrieveByEventNamesAndSmId() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        VersionedEventData eventData1 = new VersionedEventData(event1.getName(), event1.getType(), event1.getEventData(), event1.getEventSource(), event1.getExecutionVersion());
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event3 = new Event("event3", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        VersionedEventData eventData3 = new VersionedEventData(event3.getName(), event3.getType(), event3.getEventData(), event3.getEventSource(), event3.getExecutionVersion());
        this.eventsDAO.create(event3.getStateMachineInstanceId(), event3);
        Assertions.assertThat((List)this.eventsDAO.findByEventNamesAndSMId(standardTestMachine.getId(), (List)new LinkedList<String>(){
            {
                this.add("event1");
                this.add("event3");
            }
        })).containsExactly((Object[])new VersionedEventData[]{eventData1, eventData3});
    }

    @Test
    public void testDeleteInvalidEvents() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        VersionedEventData eventData1 = new VersionedEventData(event1.getName(), event1.getType(), event1.getEventData(), event1.getEventSource());
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        VersionedEventData eventData2 = new VersionedEventData(event2.getName(), event2.getType(), event2.getEventData(), event2.getEventSource());
        this.eventsDAO.create(event2.getStateMachineInstanceId(), event2);
        Event event3 = new Event("event3", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        VersionedEventData eventData3 = new VersionedEventData(event3.getName(), event3.getType(), event3.getEventData(), event3.getEventSource());
        this.eventsDAO.create(event3.getStateMachineInstanceId(), event3);
        this.eventsDAO.deleteInvalidEvents(standardTestMachine.getId(), (List)new LinkedList<String>(){
            {
                this.add("event1");
                this.add("event2");
                this.add("event3");
            }
        });
        Assertions.assertThat((List)this.eventsDAO.findByEventNamesAndSMId(standardTestMachine.getId(), (List)new LinkedList<String>(){
            {
                this.add("event3");
            }
        })).contains((Object[])new VersionedEventData[]{eventData3});
        Assertions.assertThat((List)this.eventsDAO.findByEventNamesAndSMId(standardTestMachine.getId(), (List)new LinkedList<String>(){
            {
                this.add("event1");
                this.add("event2");
            }
        })).doesNotContain((Object[])new VersionedEventData[]{eventData1, eventData2});
        this.eventsDAO.deleteInvalidEvents(standardTestMachine.getId(), new LinkedList());
        Assertions.assertThat((List)this.eventsDAO.findByEventNamesAndSMId(standardTestMachine.getId(), (List)new LinkedList<String>(){
            {
                this.add("event3");
            }
        })).contains((Object[])new VersionedEventData[]{eventData3});
    }

    @Test
    public void testRetrieveByEventNamesAndSmId_forEmptyEventNameSet() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event3 = new Event("event3", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event3.getStateMachineInstanceId(), event3);
        Assertions.assertThat((List)this.eventsDAO.findByEventNamesAndSMId(standardTestMachine.getId(), Collections.emptyList())).isEmpty();
    }

    @Test
    public void testFindBySMInstanceId() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event2);
        Event event3 = new Event("event3", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event3.getStateMachineInstanceId(), event3);
        Assertions.assertThat((List)this.eventsDAO.findBySMInstanceId(standardTestMachine.getId())).containsExactly((Object[])new Event[]{event3});
    }

    @Test
    public void testFindBySMIdAndName() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event2);
        Assertions.assertThat((Object)this.eventsDAO.findValidEventBySMIdAndName(standardTestMachine.getId(), "event1")).isEqualTo((Object)event1);
        Assertions.assertThat((Object)this.eventsDAO.findValidEventBySMIdAndName(standardTestMachine.getId(), "event2")).isNull();
    }

    @Test
    public void testFindTriggeredOrCancelledEventsNamesBySMId() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event2);
        Event event3 = new Event("event3", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event3);
        Assertions.assertThat((List)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId(standardTestMachine.getId())).containsExactly((Object[])new String[]{event3.getName()});
        Event event4 = new Event("event4", "someType", Event.EventStatus.cancelled, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event4);
        Assertions.assertThat((List)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId(standardTestMachine.getId())).containsOnly((Object[])new String[]{"event3", "event4"});
    }

    @Test
    public void testFindReplayEventsNamesBySMId() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, "eventSource1:flux_runtime_replay_internal");
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, "eventSource2:");
        this.eventsDAO.create(event2.getStateMachineInstanceId(), event2);
        Event event3 = new Event("event3", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, "eventSource3");
        this.eventsDAO.create(event3.getStateMachineInstanceId(), event3);
        Event event4 = new Event("event4", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, "eventSource4:flux_runtime_replay_internal");
        this.eventsDAO.create(event4.getStateMachineInstanceId(), event4);
        Event event5 = new Event("event5", "someType", Event.EventStatus.cancelled, standardTestMachine.getId(), null, "eventSource5:flux_runtime_replay_internal");
        this.eventsDAO.create(event5.getStateMachineInstanceId(), event5);
        Assertions.assertThat((List)this.eventsDAO.findAllValidReplayEventsNamesBySMId(standardTestMachine.getId())).hasSize(3);
        Assertions.assertThat((List)this.eventsDAO.findAllValidReplayEventsNamesBySMId(standardTestMachine.getId())).containsOnly((Object[])new String[]{"event1", "event4", "event5"});
    }

    @Test
    public void testFindTriggeredEventsBySMId() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, "flux_runtime_replay_internal");
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event2.getStateMachineInstanceId(), event2);
        Event event3 = new Event("event3", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event3.getStateMachineInstanceId(), event3);
        Event event4 = new Event("event4", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, "flux_runtime_replay_internal");
        this.eventsDAO.create(event4.getStateMachineInstanceId(), event4);
        Assertions.assertThat((List)this.eventsDAO.findTriggeredEventsBySMId(standardTestMachine.getId())).containsOnly((Object[])new Event[]{event3, event4});
    }

    @Test
    public void testFindTriggeredEventBySMIdAndName() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, "flux_runtime_replay_internal");
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event2.getStateMachineInstanceId(), event2);
        Event event3 = new Event("event3", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event3.getStateMachineInstanceId(), event3);
        Event event4 = new Event("event4", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, "flux_runtime_replay_internal");
        this.eventsDAO.create(event4.getStateMachineInstanceId(), event4);
        Event retrievedEvent3 = this.eventsDAO.findTriggeredEventBySMIdAndName(standardTestMachine.getId(), "event3");
        Assertions.assertThat((Object)retrievedEvent3).isEqualTo((Object)event3);
        Event retrievedEvent4 = this.eventsDAO.findTriggeredEventBySMIdAndName(standardTestMachine.getId(), "event4");
        Assertions.assertThat((Object)retrievedEvent4).isEqualTo((Object)event4);
    }

    @Test
    public void testGetAllEventsNameAndStatus() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, "flux_runtime_replay_internal");
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event2);
        Event event3 = new Event("event3", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event3);
        Event event4 = new Event("event4", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, "flux_runtime_replay_internal");
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event4);
        Event event5 = new Event("event5", "someType", Event.EventStatus.cancelled, standardTestMachine.getId(), null, "flux_runtime_replay_internal");
        this.eventsDAO.create(event1.getStateMachineInstanceId(), event5);
        Assertions.assertThat((Map)this.eventsDAO.getAllEventsNameAndStatus(standardTestMachine.getId(), false)).hasSize(4);
        Assertions.assertThat((Map)this.eventsDAO.getAllEventsNameAndStatus(standardTestMachine.getId(), true)).hasSize(4);
    }

    @Test
    public void testMarkEventAsCancelled() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null);
        this.eventsDAO.create(standardTestMachine.getId(), event);
        this.eventsDAO.markEventAsCancelled(standardTestMachine.getId(), "event1");
        Assertions.assertThat((Comparable)this.eventsDAO.findValidEventBySMIdAndName(standardTestMachine.getId(), "event1").getStatus()).isEqualTo((Object)Event.EventStatus.cancelled);
    }

    @Test
    public void testFindAllValidEventsByStateMachineIdAndExecutionVersionAndName() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null, Long.valueOf(0L));
        this.eventsDAO.create(standardTestMachine.getId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null, Long.valueOf(0L));
        this.eventsDAO.create(event2.getStateMachineInstanceId(), event2);
        Event event3 = new Event("event3", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, null, Long.valueOf(0L));
        this.eventsDAO.create(event3.getStateMachineInstanceId(), event3);
        Event event4 = new Event("event4", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, "flux_runtime_replay_internal", Long.valueOf(1L));
        this.eventsDAO.create(event4.getStateMachineInstanceId(), event4);
        Event event5 = new Event("event5", "someType", Event.EventStatus.cancelled, standardTestMachine.getId(), null, "flux_runtime_replay_internal", Long.valueOf(0L));
        this.eventsDAO.create(event5.getStateMachineInstanceId(), event5);
        Event event6 = new Event("event6", "someType", Event.EventStatus.triggered, standardTestMachine.getId(), null, null, Long.valueOf(1L));
        this.eventsDAO.create(event6.getStateMachineInstanceId(), event6);
        ArrayList<String> inputList = new ArrayList<String>();
        inputList.add(event1.getName());
        inputList.add(event2.getName());
        inputList.add(event3.getName());
        inputList.add(event4.getName());
        inputList.add(event5.getName());
        List outputEventList = this.eventsDAO.findAllValidEventsByStateMachineIdAndExecutionVersionAndName(standardTestMachine.getId(), inputList, Long.valueOf(0L));
        Assertions.assertThat((List)outputEventList).contains((Object[])new Event[]{event1, event3, event5});
        Assertions.assertThat((List)outputEventList).doesNotContain((Object[])new Event[]{event2, event4, event6});
    }

    @Test
    public void testFindBySmIdAndNameAndVersion() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachine();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Event event1 = new Event("event1", "someType", Event.EventStatus.pending, standardTestMachine.getId(), null, null, Long.valueOf(0L));
        this.eventsDAO.create(standardTestMachine.getId(), event1);
        Event event2 = new Event("event2", "someType", Event.EventStatus.invalid, standardTestMachine.getId(), null, null, Long.valueOf(1L));
        this.eventsDAO.create(event2.getStateMachineInstanceId(), event2);
        Assertions.assertThat((Object)this.eventsDAO.findBySmIdAndNameAndVersion(standardTestMachine.getId(), event1.getName(), Long.valueOf(0L))).isEqualTo((Object)event1);
        Assertions.assertThat((Object)this.eventsDAO.findBySmIdAndNameAndVersion(standardTestMachine.getId(), event2.getName(), Long.valueOf(1L))).isEqualTo((Object)event2);
    }
}

