/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.testkit.TestActorRef;
import akka.testkit.TestProbe;
import com.flipkart.flux.MockActorRef;
import com.flipkart.flux.api.core.TaskExecutionMessage;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.flux.metrics.iface.MetricsClient;
import com.flipkart.flux.resource.ExecutionApiResource;
import com.flipkart.flux.util.TestUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import scala.concurrent.Future;

@RunWith(value=MockitoJUnitRunner.class)
public class ExecutionApiResourceTest {
    @Mock
    RouterRegistry routerRegistry;
    @Mock
    MetricsClient metricsClient;
    static TestActorRef<MockActorRef> mockActor;
    ExecutionApiResource executionApiResource;
    TestProbe testProbe;
    static ActorSystem actorSystem;

    @BeforeClass
    public static void setUp() {
        actorSystem = ActorSystem.create((String)"FluxExecutionSystem", (Config)ConfigFactory.load((String)"testAkkaActorSystem.conf"));
        mockActor = TestActorRef.create((ActorSystem)actorSystem, (Props)Props.create(MockActorRef.class, (Object[])new Object[0]));
    }

    @AfterClass
    public static void cleanUp() {
        Future x = actorSystem.terminate();
        while (!x.isCompleted()) {
        }
    }

    @Before
    public void beforeEachTest() {
        this.executionApiResource = new ExecutionApiResource(this.routerRegistry, this.metricsClient);
    }

    @AfterClass
    public static void done() {
        mockActor.stop();
        actorSystem.terminate();
    }

    @Test
    public void receiveExecutionMessage_shouldLookupRouterAndSendMessage() throws Exception {
        TaskExecutionMessage msg = TestUtils.getStandardTaskExecutionMessage();
        Mockito.when((Object)this.routerRegistry.getRouter(msg.getRouterName())).thenReturn(mockActor);
        this.executionApiResource.receiveTaskAndExecutionData(msg);
        ((RouterRegistry)Mockito.verify((Object)this.routerRegistry, (VerificationMode)Mockito.times((int)1))).getRouter(msg.getRouterName());
        ((MockActorRef)mockActor.underlyingActor()).assertMessageReceived((Object)msg.getAkkaMessage(), 1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.routerRegistry});
    }
}

