/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.rule;

import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.eventscheduler.model.ScheduledEvent;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.flux.shard.ShardId;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;
import org.junit.rules.ExternalResource;

@Singleton
public class DbClearRule
extends ExternalResource {
    private final Map<ShardId, SessionFactory> fluxRWSessionFactoriesMap;
    private final SessionFactoryContext schedulerSessionFactoryContext;
    private static Class[] fluxTables = new Class[]{StateMachine.class, State.class, AuditRecord.class, Event.class, StateTraversalPath.class};
    private static Class[] fluxSchedulerTables = new Class[]{ScheduledMessage.class, ScheduledEvent.class};

    @Inject
    public DbClearRule(@Named(value="fluxRWSessionFactoriesMap") Map<ShardId, SessionFactory> fluxRWSessionFactoriesMap, @Named(value="schedulerSessionFactoriesContext") SessionFactoryContext schedulerSessionFactoryContext) {
        this.fluxRWSessionFactoriesMap = fluxRWSessionFactoriesMap;
        this.schedulerSessionFactoryContext = schedulerSessionFactoryContext;
    }

    protected void before() throws Throwable {
        this.explicitClearTables();
    }

    public void explicitClearTables() {
        this.fluxRWSessionFactoriesMap.entrySet().forEach(entry -> this.clearDb(fluxTables, (SessionFactory)entry.getValue()));
        this.clearDb(fluxSchedulerTables, this.schedulerSessionFactoryContext.getSchedulerSessionFactory());
        this.schedulerSessionFactoryContext.clear();
    }

    private void clearDb(Class[] tables, SessionFactory sessionFactory) {
        Session session = sessionFactory.openSession();
        ManagedSessionContext.bind((Session)session);
        Transaction tx = session.beginTransaction();
        try {
            session.createSQLQuery("set foreign_key_checks=0").executeUpdate();
            for (Class anEntity : tables) {
                session.createSQLQuery("delete from " + anEntity.getSimpleName() + "s").executeUpdate();
            }
            session.createSQLQuery("set foreign_key_checks=1").executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new RuntimeException("Unable to clear tables. Exception: " + e.getMessage(), e);
        }
        finally {
            if (session != null) {
                ManagedSessionContext.unbind((SessionFactory)sessionFactory);
                session.close();
            }
        }
    }
}

