/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.dao.AbstractDAO;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.google.inject.name.Named;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AuditDAOImpl
extends AbstractDAO<AuditRecord>
implements AuditDAO {
    @Inject
    public AuditDAOImpl(@Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<AuditRecord> findBySMInstanceId(String stateMachineInstanceId) {
        Criteria criteria = this.currentSession().createCriteria(AuditRecord.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId));
        List records = criteria.list();
        return records;
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public AuditRecord create(String stateMachineId, AuditRecord auditRecord) {
        if (auditRecord.getErrors() != null && auditRecord.getErrors().toCharArray().length > 999) {
            auditRecord.setErrors(auditRecord.getErrors().substring(0, 995));
        }
        return super.save(auditRecord);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public AuditRecord findById(String stateMachineId, Long id) {
        return (AuditRecord)super.findById(AuditRecord.class, id);
    }

    @Override
    public AuditRecord create_NonTransactional(AuditRecord auditRecord, Session session) {
        if (auditRecord.getErrors() != null && auditRecord.getErrors().toCharArray().length > 999) {
            auditRecord.setErrors(auditRecord.getErrors().substring(0, 995));
        }
        session.save((Object)auditRecord);
        return auditRecord;
    }
}

