/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.representation;

import com.flipkart.flux.api.ClientElbDefinition;
import com.flipkart.flux.clientelb.dao.iface.ClientElbDAO;
import com.flipkart.flux.domain.ClientElb;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class ClientElbPersistenceService {
    private ClientElbDAO clientElbDAO;
    private LoadingCache<String, String> clientElbCache;
    private static final Logger logger = LogManager.getLogger(ClientElbPersistenceService.class);

    @Inject
    public ClientElbPersistenceService(final ClientElbDAO clientElbDAO, @Named(value="elbCache.maxSize") Integer MAX_CACHE_SIZE) {
        this.clientElbDAO = clientElbDAO;
        this.clientElbCache = CacheBuilder.newBuilder().maximumSize((long)MAX_CACHE_SIZE.intValue()).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String clientElbId) throws Exception {
                return clientElbDAO.findById(clientElbId).getElbUrl();
            }
        });
    }

    public long getClientElbCacheSize() {
        return this.clientElbCache.size();
    }

    public boolean clientElbCacheContainsKey(String key) {
        return this.clientElbCache.asMap().containsKey(key);
    }

    public ClientElb convertClientElbDefinitionToClientElb(ClientElbDefinition clientElbDefinition) {
        return new ClientElb(clientElbDefinition.getId(), clientElbDefinition.getElbUrl());
    }

    public ClientElb persistClientElb(String clientId, ClientElbDefinition clientElbDefinition) {
        ClientElb clientElb = new ClientElb(clientElbDefinition.getId(), clientElbDefinition.getElbUrl());
        return this.clientElbDAO.create(clientElb);
    }

    public String findByIdClientElb(String clientId) {
        String clientElbUrl = null;
        try {
            clientElbUrl = (String)this.clientElbCache.get((Object)clientId);
            if (clientElbUrl == null) {
                logger.error("ClientElbCache entry not found in both DB and cache. Try registering ClientElb again.");
            }
        }
        catch (ExecutionException e) {
            logger.error("Error occured while accessing ClientElbCache Entry {} {}", (Object)clientId, (Object)e.getMessage(), (Object)e.getStackTrace());
        }
        catch (Exception ex) {
            logger.error("Errored occured while loading entity {} in Cache {}", (Object)clientId, (Object)ex);
        }
        return clientElbUrl;
    }

    public void updateClientElb(String clientId, String clientElbUrl) {
        this.clientElbDAO.updateElbUrl(clientId, clientElbUrl);
        this.clientElbCache.refresh((Object)clientId);
        logger.info("After ClientElb entry update, cache contains: {}", (Object)this.clientElbCache.asMap());
    }

    public void deleteClientElb(String clientId) {
        this.clientElbDAO.delete(clientId);
        if (this.clientElbCache.asMap().containsKey(clientId)) {
            this.clientElbCache.asMap().remove(clientId);
        }
        logger.info("After ClientElb entry delete, cache contains: {}", (Object)this.clientElbCache.asMap());
    }
}

