/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import akka.actor.ActorRef;
import com.codahale.metrics.annotation.Timed;
import com.flipkart.flux.api.core.TaskExecutionMessage;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.flux.metrics.iface.MetricsClient;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
@Path(value="/api/execution")
@Named
public class ExecutionApiResource {
    private static final Logger logger = LogManager.getLogger(ExecutionApiResource.class);
    private RouterRegistry routerRegistry;
    private MetricsClient metricsClient;

    @Inject
    public ExecutionApiResource(RouterRegistry routerRegistry, MetricsClient metricsClient) {
        this.routerRegistry = routerRegistry;
        this.metricsClient = metricsClient;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    public Response receiveTaskAndExecutionData(TaskExecutionMessage taskExecutionMessage) {
        TaskAndEvents msg = taskExecutionMessage.getAkkaMessage();
        String routerName = taskExecutionMessage.getRouterName();
        logger.info("Received taskExecutionMessage for stateMachine {} taskId {} taskName {} tastExecutionVersion: {}", (Object)msg.getStateMachineId(), (Object)msg.getTaskId(), (Object)msg.getTaskName(), (Object)msg.getTaskExecutionVersion());
        try {
            ActorRef router = this.routerRegistry.getRouter(routerName);
            if (router == null) {
                logger.error("Corresponding router {} for the execution message not found", (Object)taskExecutionMessage.getRouterName());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Akka router for this executionMessage not found").build();
            }
            logger.info("Sending msg to router: {} to execute state machine: {} task: {} with execution version: {}", (Object)router.path(), (Object)msg.getStateMachineId(), (Object)msg.getTaskId(), (Object)msg.getTaskExecutionVersion());
            router.tell((Object)msg, ActorRef.noSender());
            this.metricsClient.incCounter("stateMachine." + msg.getStateMachineName() + ".task." + msg.getTaskName() + ".queueSize");
        }
        catch (Exception ex) {
            logger.error("Unable to append the task to the Actor Queue {}", (Throwable)ex);
            return Response.serverError().entity(ex.getCause() != null ? ex.getCause().getMessage() : null).build();
        }
        return Response.accepted().build();
    }
}

