/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.controller;

import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.testkit.TestActorRef;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.MockActorRef;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.ExecutionUpdateData;
import com.flipkart.flux.api.VersionedEventData;
import com.flipkart.flux.api.core.TaskExecutionMessage;
import com.flipkart.flux.controller.WorkFlowExecutionController;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.exception.IllegalEventException;
import com.flipkart.flux.exception.TraversalPathException;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.flux.metrics.iface.MetricsClient;
import com.flipkart.flux.persistence.dao.iface.AuditDAO;
import com.flipkart.flux.persistence.dao.iface.EventsDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.persistence.dao.iface.StatesDAO;
import com.flipkart.flux.representation.ClientElbPersistenceService;
import com.flipkart.flux.representation.ReplayEventPersistenceService;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import com.flipkart.flux.taskDispatcher.ExecutionNodeTaskDispatcher;
import com.flipkart.flux.util.TestUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkFlowExecutionControllerTest {
    @Mock
    StateMachinesDAO stateMachinesDAO;
    @Mock
    EventsDAO eventsDAO;
    @Mock
    StatesDAO statesDAO;
    @Mock
    AuditDAO auditDAO;
    @Mock
    StateTraversalPathDAO stateTraversalPathDAO;
    TestActorRef<MockActorRef> mockActor;
    ActorSystem actorSystem;
    @Mock
    private RouterRegistry routerRegistry;
    @Mock
    private ExecutionNodeTaskDispatcher executionNodeTaskDispatcher;
    @Mock
    private RedriverRegistry redriverRegistry;
    @Mock
    private MetricsClient metricsClient;
    @Mock
    private ClientElbPersistenceService clientElbPersistenceService;
    @Mock
    private ReplayEventPersistenceService replayEventPersistenceService;
    private WorkFlowExecutionController workFlowExecutionController;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() throws Exception {
        Thread.sleep(1000L);
        this.workFlowExecutionController = new WorkFlowExecutionController(this.eventsDAO, this.stateMachinesDAO, this.statesDAO, this.auditDAO, this.stateTraversalPathDAO, this.executionNodeTaskDispatcher, this.redriverRegistry, this.metricsClient, this.clientElbPersistenceService, this.replayEventPersistenceService);
        Mockito.when((Object)this.stateMachinesDAO.findById(ArgumentMatchers.anyString())).thenReturn((Object)TestUtils.getStandardTestMachineWithId());
        Mockito.when((Object)this.clientElbPersistenceService.findByIdClientElb(ArgumentMatchers.anyString())).thenReturn((Object)"http://localhost:9997");
        this.actorSystem = ActorSystem.create((String)"testActorSystem", (Config)ConfigFactory.load((String)"testAkkaActorSystem"));
        this.mockActor = TestActorRef.create((ActorSystem)this.actorSystem, (Props)Props.create(MockActorRef.class, (Object[])new Object[0]));
        this.objectMapper = new ObjectMapper();
    }

    @After
    public void tearDown() throws Exception {
        this.actorSystem.terminate();
    }

    @Test
    public void testEventPost_shouldForwardToTaskDispatcher() throws Exception {
        VersionedEventData testEventData = new VersionedEventData("event0", "java.lang.String", "42", "runtime");
        Mockito.when((Object)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName("standard-machine", "event0", Long.valueOf(0L))).thenReturn((Object)new Event("event0", "java.lang.String", Event.EventStatus.pending, "standard-machine", null, null));
        VersionedEventData[] expectedEvents = new VersionedEventData[]{new VersionedEventData("event0", "java.lang.String", "42", "runtime")};
        Mockito.when((Object)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId("standard-machine")).thenReturn(Collections.singletonList("event0"));
        Mockito.when((Object)this.executionNodeTaskDispatcher.forwardExecutionMessage(ArgumentMatchers.anyString(), (TaskExecutionMessage)ArgumentMatchers.any())).thenReturn((Object)Response.Status.ACCEPTED.getStatusCode());
        this.workFlowExecutionController.postEvent(testEventData, "standard-machine");
        State state = this.stateMachinesDAO.findById("standard-machine").getStates().stream().filter(s -> s.getId() == 4L).findFirst().orElse(null);
        TaskExecutionMessage msg = new TaskExecutionMessage();
        msg.setRouterName(WorkFlowExecutionController.getRouterName((String)state.getTask()));
        msg.setAkkaMessage(new TaskAndEvents(state.getName(), state.getTask(), state.getId(), expectedEvents, state.getStateMachineId(), "test_state_machine", state.getOutputEvent(), state.getRetryCount().longValue()));
        ((ExecutionNodeTaskDispatcher)Mockito.verify((Object)this.executionNodeTaskDispatcher, (VerificationMode)Mockito.times((int)1))).forwardExecutionMessage("http://localhost:9997/api/execution", msg);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.executionNodeTaskDispatcher});
    }

    @Test
    public void testEventPost_shouldNotFetchEventDataFromDBIfStateIsDependantOnSingleEvent() throws Exception {
        VersionedEventData testEventData = new VersionedEventData("event1", "foo", "someStringData", "runtime");
        Mockito.when((Object)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName("standard-machine", "event1", Long.valueOf(0L))).thenReturn((Object)new Event("event1", "foo", Event.EventStatus.pending, "1", null, null));
        Mockito.when((Object)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId("standard-machine")).thenReturn(Collections.singletonList("event1"));
        this.workFlowExecutionController.postEvent(testEventData, "standard-machine");
        ((EventsDAO)Mockito.verify((Object)this.eventsDAO, (VerificationMode)Mockito.times((int)0))).findByEventNamesAndSMId("standard-machine", Collections.singletonList("event1"));
    }

    @Test
    public void testEventPost_taskRedriveDelay() throws Exception {
        VersionedEventData testEventData1 = new VersionedEventData("event1", "java.lang.String", "42", "runtime");
        Mockito.when((Object)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName("standard-machine", "event1", Long.valueOf(0L))).thenReturn((Object)new Event("event1", "java.lang.String", Event.EventStatus.pending, "1", null, null));
        VersionedEventData[] expectedEvents1 = new VersionedEventData[]{new VersionedEventData("event1", "java.lang.String", "42", "runtime")};
        Mockito.when((Object)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId("standard-machine")).thenReturn(Collections.singletonList("event1"));
        this.workFlowExecutionController.postEvent(testEventData1, "standard-machine");
        VersionedEventData testEventData0 = new VersionedEventData("event0", "java.lang.String", "42", "runtime");
        Mockito.when((Object)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName("standard-machine", "event0", Long.valueOf(0L))).thenReturn((Object)new Event("event0", "java.lang.String", Event.EventStatus.pending, "1", null, null));
        VersionedEventData[] expectedEvents0 = new VersionedEventData[]{new VersionedEventData("event0", "java.lang.String", "42", "runtime")};
        Mockito.when((Object)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId("standard-machine")).thenReturn(Collections.singletonList("event0"));
        this.workFlowExecutionController.postEvent(testEventData0, "standard-machine");
        Thread.sleep(2000L);
        ((RedriverRegistry)Mockito.verify((Object)this.redriverRegistry)).registerTask(Long.valueOf(2L), "standard-machine", 32800L, Long.valueOf(0L));
        ((RedriverRegistry)Mockito.verify((Object)this.redriverRegistry)).registerTask(Long.valueOf(4L), "standard-machine", 8400L, Long.valueOf(0L));
    }

    @Test
    public void testEventPost_shouldNotSendExecuteTaskIfItIsAlreadyCompleted() throws Exception {
        VersionedEventData testEventData = new VersionedEventData("event0", "java.lang.String", "42", "runtime");
        Mockito.when((Object)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName("standard-machine", "event0", Long.valueOf(0L))).thenReturn((Object)new Event("event0", "java.lang.String", Event.EventStatus.pending, "1", null, null));
        Mockito.when((Object)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId("standard-machine")).thenReturn(Collections.singletonList("event0"));
        Mockito.when((Object)this.executionNodeTaskDispatcher.forwardExecutionMessage(ArgumentMatchers.anyString(), (TaskExecutionMessage)ArgumentMatchers.any())).thenReturn((Object)Response.Status.ACCEPTED.getStatusCode());
        this.workFlowExecutionController.postEvent(testEventData, "standard-machine");
        State state = this.stateMachinesDAO.findById("standard-machine").getStates().stream().filter(s -> s.getId() == 4L).findFirst().orElse(null);
        state.setStatus(Status.completed);
        this.workFlowExecutionController.postEvent(testEventData, "standard-machine");
        ((ExecutionNodeTaskDispatcher)Mockito.verify((Object)this.executionNodeTaskDispatcher, (VerificationMode)Mockito.times((int)1))).forwardExecutionMessage(ArgumentMatchers.anyString(), (TaskExecutionMessage)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.executionNodeTaskDispatcher});
    }

    @Test
    public void testEventPost_shouldSendExecuteTaskIfItIsNotCompleted() throws Exception {
        VersionedEventData testEventData = new VersionedEventData("event0", "java.lang.String", "42", "runtime");
        Mockito.when((Object)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName("standard-machine", "event0", Long.valueOf(0L))).thenReturn((Object)new Event("event0", "java.lang.String", Event.EventStatus.pending, "1", null, null));
        Mockito.when((Object)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId("standard-machine")).thenReturn(Collections.singletonList("event0"));
        Mockito.when((Object)this.executionNodeTaskDispatcher.forwardExecutionMessage(ArgumentMatchers.anyString(), (TaskExecutionMessage)ArgumentMatchers.any())).thenReturn((Object)Response.Status.ACCEPTED.getStatusCode());
        this.workFlowExecutionController.postEvent(testEventData, "standard-machine");
        StateMachine stateMachine = this.stateMachinesDAO.findById("standard-machine");
        State state = this.stateMachinesDAO.findById("standard-machine").getStates().stream().filter(s -> s.getId() == 4L).findFirst().orElse(null);
        state.setStatus(Status.errored);
        this.workFlowExecutionController.postEvent(testEventData, "standard-machine");
        ((ExecutionNodeTaskDispatcher)Mockito.verify((Object)this.executionNodeTaskDispatcher, (VerificationMode)Mockito.times((int)2))).forwardExecutionMessage(ArgumentMatchers.anyString(), (TaskExecutionMessage)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.executionNodeTaskDispatcher});
    }

    @Test
    public void testEventPost_shouldNotSendExecuteTaskIfItIsCancelled() throws Exception {
        VersionedEventData testEventData = new VersionedEventData("event0", "java.lang.String", "42", "runtime");
        Mockito.when((Object)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName("standard-machine", "event0", Long.valueOf(0L))).thenReturn((Object)new Event("event0", "java.lang.String", Event.EventStatus.pending, "1", null, null));
        Mockito.when((Object)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId("standard-machine")).thenReturn(Collections.singletonList("event0"));
        Mockito.when((Object)this.executionNodeTaskDispatcher.forwardExecutionMessage(ArgumentMatchers.anyString(), (TaskExecutionMessage)ArgumentMatchers.any())).thenReturn((Object)Response.Status.ACCEPTED.getStatusCode());
        this.workFlowExecutionController.postEvent(testEventData, "standard-machine");
        StateMachine stateMachine = this.stateMachinesDAO.findById("standard-machine");
        State state = stateMachine.getStates().stream().filter(s -> s.getId() == 4L).findFirst().orElse(null);
        state.setStatus(Status.cancelled);
        this.workFlowExecutionController.postEvent(testEventData, "standard-machine");
        ((ExecutionNodeTaskDispatcher)Mockito.verify((Object)this.executionNodeTaskDispatcher, (VerificationMode)Mockito.times((int)1))).forwardExecutionMessage(ArgumentMatchers.anyString(), (TaskExecutionMessage)ArgumentMatchers.any());
    }

    @Test
    public void testCancelPath_shouldCancelPathTillJoinNode() throws Exception {
        HashMap<String, Event.EventStatus> eventStatusHashMap = new HashMap<String, Event.EventStatus>(){
            {
                this.put("event1", Event.EventStatus.triggered);
                this.put("event2", Event.EventStatus.triggered);
                this.put("event3", Event.EventStatus.pending);
                this.put("event4", Event.EventStatus.pending);
                this.put("event5", Event.EventStatus.pending);
            }
        };
        String outputEvent1 = null;
        String outputEvent2 = null;
        String outputEvent3 = null;
        String outputEvent4 = null;
        String outputEvent5 = null;
        String outputEvent6 = null;
        try {
            outputEvent1 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event1", "SomeEvent.class"));
            outputEvent2 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event2", "SomeEvent.class"));
            outputEvent3 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event3", "SomeEvent.class"));
            outputEvent4 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event4", "SomeEvent.class"));
            outputEvent5 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event5", "SomeEvent.class"));
            outputEvent6 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event6", "SomeEvent.class"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final State state1 = new State(Long.valueOf(1L), "state1", null, null, null, null, new ArrayList(), Long.valueOf(0L), Long.valueOf(1000L), outputEvent1, Status.initialized, null, Long.valueOf(0L), "state-machine-cancel-path", Long.valueOf(1L));
        final State state2 = new State(Long.valueOf(1L), "state2", null, null, null, null, (List)new ArrayList<String>(){
            {
                this.add("event1");
            }
        }, Long.valueOf(0L), Long.valueOf(1000L), outputEvent2, Status.initialized, null, Long.valueOf(0L), "state-machine-cancel-path", Long.valueOf(2L));
        final State state3 = new State(Long.valueOf(1L), "state3", null, null, null, null, (List)new ArrayList<String>(){
            {
                this.add("event2");
                this.add("event6");
            }
        }, Long.valueOf(0L), Long.valueOf(1000L), null, Status.initialized, null, Long.valueOf(0L), "state-machine-cancel-path", Long.valueOf(3L));
        final State state4 = new State(Long.valueOf(1L), "state4", null, null, null, null, (List)new ArrayList<String>(){
            {
                this.add("event1");
            }
        }, Long.valueOf(0L), Long.valueOf(1000L), outputEvent3, Status.initialized, null, Long.valueOf(0L), "state-machine-cancel-path", Long.valueOf(4L));
        final State state5 = new State(Long.valueOf(1L), "state5", null, null, null, null, (List)new ArrayList<String>(){
            {
                this.add("event3");
            }
        }, Long.valueOf(0L), Long.valueOf(1000L), outputEvent4, Status.initialized, null, Long.valueOf(0L), "state-machine-cancel-path", Long.valueOf(5L));
        final State state6 = new State(Long.valueOf(1L), "state6", null, null, null, null, (List)new ArrayList<String>(){
            {
                this.add("event3");
            }
        }, Long.valueOf(0L), Long.valueOf(1000L), outputEvent5, Status.initialized, null, Long.valueOf(0L), "state-machine-cancel-path", Long.valueOf(6L));
        final State state7 = new State(Long.valueOf(1L), "state7", null, null, null, null, (List)new ArrayList<String>(){
            {
                this.add("event4");
                this.add("event5");
            }
        }, Long.valueOf(0L), Long.valueOf(1000L), outputEvent6, Status.initialized, null, Long.valueOf(0L), "state-machine-cancel-path", Long.valueOf(7L));
        HashSet<State> states = new HashSet<State>(){
            {
                this.add(state1);
                this.add(state2);
                this.add(state3);
                this.add(state4);
                this.add(state5);
                this.add(state6);
                this.add(state7);
            }
        };
        StateMachine stateMachine = new StateMachine("state-machine-cancel-path", Long.valueOf(1L), "state_machine_1", null, (Set)states, "client_elb_id_1");
        VersionedEventData testEventData = new VersionedEventData("event3", null, null, "runtime", Boolean.valueOf(true), Long.valueOf(0L));
        Mockito.when((Object)this.eventsDAO.getAllEventsNameAndStatus("state-machine-cancel-path", true)).thenReturn((Object)eventStatusHashMap);
        Mockito.when((Object)this.stateMachinesDAO.findById("state-machine-cancel-path")).thenReturn((Object)stateMachine);
        Set executableStates = this.workFlowExecutionController.cancelPath(stateMachine.getId(), testEventData);
        Assertions.assertThat((int)executableStates.size()).isEqualTo(1);
        Assertions.assertThat((boolean)executableStates.contains("state3"));
        ((EventsDAO)Mockito.verify((Object)this.eventsDAO)).markEventAsCancelled("state-machine-cancel-path", "event3");
        ((EventsDAO)Mockito.verify((Object)this.eventsDAO)).markEventAsCancelled("state-machine-cancel-path", "event4");
        ((EventsDAO)Mockito.verify((Object)this.eventsDAO)).markEventAsCancelled("state-machine-cancel-path", "event5");
        ((EventsDAO)Mockito.verify((Object)this.eventsDAO)).markEventAsCancelled("state-machine-cancel-path", "event6");
        ((StatesDAO)Mockito.verify((Object)this.statesDAO)).updateStatus("state-machine-cancel-path", Long.valueOf(5L), Status.cancelled);
        ((StatesDAO)Mockito.verify((Object)this.statesDAO)).updateStatus("state-machine-cancel-path", Long.valueOf(6L), Status.cancelled);
        ((StatesDAO)Mockito.verify((Object)this.statesDAO)).updateStatus("state-machine-cancel-path", Long.valueOf(7L), Status.cancelled);
    }

    @Test
    public void testUpdateTaskStatusBehaviourWhenTaskStatusIsUpdatedToRunning() {
        Mockito.when((Object)this.statesDAO.findById("random-state-machine", Long.valueOf(1L))).thenReturn((Object)new State(Long.valueOf(1L), "random-state", null, null, null, null, new ArrayList(), Long.valueOf(0L), Long.valueOf(1000L), null, Status.initialized, null, Long.valueOf(0L), "random-state-machine", Long.valueOf(1L)));
        this.workFlowExecutionController.updateTaskStatus("random-state-machine", Long.valueOf(1L), Long.valueOf(0L), new ExecutionUpdateData("random-state-machine", "someStateMachine", "someTask", Long.valueOf(1L), com.flipkart.flux.api.Status.running, 0L, 1L, "", false, ""));
        ((StatesDAO)Mockito.verify((Object)this.statesDAO)).updateStatus("random-state-machine", Long.valueOf(1L), Status.running);
        ((AuditDAO)Mockito.verify((Object)this.auditDAO)).create("random-state-machine", new AuditRecord("random-state-machine", Long.valueOf(1L), Long.valueOf(1L), Status.running, null, ""));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.redriverRegistry});
    }

    @Test
    public void testUpdateTaskStatusBehaviourWhenTaskStatusIsUpdatedToCompleted() {
        Mockito.when((Object)this.statesDAO.findById("random-state-machine", Long.valueOf(1L))).thenReturn((Object)new State(Long.valueOf(1L), "random-state", null, null, null, null, new ArrayList(), Long.valueOf(0L), Long.valueOf(1000L), null, Status.initialized, null, Long.valueOf(0L), "random-state-machine", Long.valueOf(1L)));
        this.workFlowExecutionController.updateTaskStatus("random-state-machine", Long.valueOf(1L), Long.valueOf(0L), new ExecutionUpdateData("random-state-machine", "someStateMachine", "someTask", Long.valueOf(1L), com.flipkart.flux.api.Status.completed, 0L, 1L, "", true, ""));
        ((StatesDAO)Mockito.verify((Object)this.statesDAO)).updateStatus("random-state-machine", Long.valueOf(1L), Status.completed);
        ((AuditDAO)Mockito.verify((Object)this.auditDAO)).create("random-state-machine", new AuditRecord("random-state-machine", Long.valueOf(1L), Long.valueOf(1L), Status.completed, null, ""));
        ((RedriverRegistry)Mockito.verify((Object)this.redriverRegistry)).deRegisterTask("random-state-machine", Long.valueOf(1L), Long.valueOf(0L));
    }

    @Test(expected=TraversalPathException.class)
    public void testPostReplayEventWithNoTraversalPathExists() throws IllegalEventException, IOException {
        String onEntryHook = "com.flipkart.flux.dao.DummyOnEntryHook";
        String task = "com.flipkart.flux.dao.TestWorkflow_dummyTask";
        String onExitHook = "com.flipkart.flux.dao.DummyOnExitHook";
        Event testReplayEvent = new Event("event3", "someType", Event.EventStatus.pending, "ReplayEventTestStateMachine1", null, "flux_runtime_replay_internal");
        Event event1 = new Event("event1", "someEvent", Event.EventStatus.pending, "ReplayEventTestStateMachine1", null, null);
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add(testReplayEvent.getName());
        String outputEvent1 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event1", "SomeEvent"));
        State state1 = new State(Long.valueOf(2L), "state1", "desc1", onEntryHook, task, onExitHook, Collections.emptyList(), Long.valueOf(3L), Long.valueOf(60L), outputEvent1, null, null, Long.valueOf(0L), "ReplayEventTestStateMachine1", Long.valueOf(1L));
        State state2 = new State(Long.valueOf(2L), "state2", "desc2", onEntryHook, task, onExitHook, dependencies, Long.valueOf(3L), Long.valueOf(60L), outputEvent1, Status.completed, null, Long.valueOf(0L), "ReplayEventTestStateMachine1", Long.valueOf(2L), Short.valueOf((short)5), Short.valueOf((short)2), Boolean.TRUE);
        HashSet<State> states = new HashSet<State>();
        states.add(state1);
        states.add(state2);
        StateMachine stateMachine1 = new StateMachine("ReplayEventTestStateMachine1", Long.valueOf(2L), "SM_name", "SM_desc", states, "client_elb_id_1");
        Mockito.when((Object)this.statesDAO.findStateIdByEventName(stateMachine1.getId(), testReplayEvent.getName())).thenReturn((Object)state2.getId());
        Mockito.when((Object)this.statesDAO.findById(stateMachine1.getId(), state2.getId())).thenReturn((Object)state2);
        Mockito.when((Object)this.stateTraversalPathDAO.findById(stateMachine1.getId(), state2.getId())).thenReturn(Optional.empty());
        EventData eventData = new EventData(testReplayEvent.getName(), testReplayEvent.getType(), testReplayEvent.getEventData(), testReplayEvent.getEventSource());
        this.workFlowExecutionController.postReplayEvent(eventData, stateMachine1);
        ((StatesDAO)Mockito.verify((Object)this.statesDAO)).incrementReplayableRetries("ReplayEventTestStateMachine1", Long.valueOf(2L), Short.valueOf((short)10));
    }

    @Test(expected=IllegalEventException.class)
    public void testPostReplayEventWithNoDependentState() throws IllegalEventException, IOException {
        String onEntryHook = "com.flipkart.flux.dao.DummyOnEntryHook";
        String task = "com.flipkart.flux.dao.TestWorkflow_dummyTask";
        String onExitHook = "com.flipkart.flux.dao.DummyOnExitHook";
        Event testReplayEvent = new Event("event3", "someType", Event.EventStatus.pending, "ReplayEventTestStateMachine1", null, "flux_runtime_replay_internal");
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add(testReplayEvent.getName());
        String outputEvent1 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event1", "SomeEvent"));
        State state1 = new State(Long.valueOf(2L), "state1", "desc1", onEntryHook, task, onExitHook, Collections.emptyList(), Long.valueOf(3L), Long.valueOf(60L), outputEvent1, null, null, Long.valueOf(0L), "ReplayEventTestStateMachine1", Long.valueOf(1L));
        HashSet<State> states = new HashSet<State>();
        states.add(state1);
        StateMachine stateMachine1 = new StateMachine("ReplayEventTestStateMachine1", Long.valueOf(2L), "SM_name", "SM_desc", states, "client_elb_id_1");
        Mockito.when((Object)this.statesDAO.findStateIdByEventName(stateMachine1.getId(), testReplayEvent.getName())).thenReturn(null);
        EventData eventData = new EventData(testReplayEvent.getName(), testReplayEvent.getType(), testReplayEvent.getEventData(), testReplayEvent.getEventSource());
        this.workFlowExecutionController.postReplayEvent(eventData, stateMachine1);
    }

    @Test(expected=IllegalEventException.class)
    public void testPostReplayEventWithDependentStateNotReplayable() throws IllegalEventException, IOException {
        String onEntryHook = "com.flipkart.flux.dao.DummyOnEntryHook";
        String task = "com.flipkart.flux.dao.TestWorkflow_dummyTask";
        String onExitHook = "com.flipkart.flux.dao.DummyOnExitHook";
        Event testReplayEvent = new Event("event3", "someType", Event.EventStatus.pending, "ReplayEventTestStateMachine1", null, "flux_runtime_replay_internal");
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add(testReplayEvent.getName());
        String outputEvent1 = this.objectMapper.writeValueAsString((Object)new EventDefinition("event1", "SomeEvent"));
        State state1 = new State(Long.valueOf(2L), "state1", "desc1", onEntryHook, task, onExitHook, dependencies, Long.valueOf(3L), Long.valueOf(60L), outputEvent1, null, null, Long.valueOf(0L), "ReplayEventTestStateMachine1", Long.valueOf(1L));
        HashSet<State> states = new HashSet<State>();
        states.add(state1);
        StateMachine stateMachine1 = new StateMachine("ReplayEventTestStateMachine1", Long.valueOf(2L), "SM_name", "SM_desc", states, "client_elb_id_1");
        Mockito.when((Object)this.statesDAO.findStateIdByEventName(stateMachine1.getId(), testReplayEvent.getName())).thenReturn((Object)1L);
        Mockito.when((Object)this.statesDAO.findById(stateMachine1.getId(), Long.valueOf(1L))).thenReturn((Object)state1);
        EventData eventData = new EventData(testReplayEvent.getName(), testReplayEvent.getType(), testReplayEvent.getEventData(), testReplayEvent.getEventSource());
        this.workFlowExecutionController.postReplayEvent(eventData, stateMachine1);
    }

    @Test
    public void testRedriveTask_InvalidExecutionNumber() {
        Mockito.when((Object)this.statesDAO.findById("random-state-machine", Long.valueOf(1L))).thenReturn((Object)new State(Long.valueOf(1L), "random-state", null, null, null, null, new ArrayList(), Long.valueOf(0L), Long.valueOf(1000L), null, Status.initialized, null, Long.valueOf(0L), "random-state-machine", Long.valueOf(1L), Short.valueOf((short)3), Short.valueOf((short)0), Boolean.valueOf(true), Long.valueOf(2L)));
        this.workFlowExecutionController.redriveTask("random-state-machine", Long.valueOf(1L), Long.valueOf(0L));
        ((RedriverRegistry)Mockito.verify((Object)this.redriverRegistry, (VerificationMode)Mockito.times((int)1))).deRegisterTask("random-state-machine", Long.valueOf(1L), Long.valueOf(0L));
    }
}

