/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateMachineStatus;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.persistence.dao.iface.EventsDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.rule.DbClearWithTestSMRule;
import com.flipkart.flux.runner.GuiceJunit4Runner;
import com.flipkart.flux.runner.Modules;
import com.flipkart.flux.util.TestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GuiceJunit4Runner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, OrchestrationTaskModule.class, FluxClientInterceptorModule.class})
public class StateMachinesDAOTest {
    @InjectFromRole
    private EventsDAO eventsDAO;
    @InjectFromRole
    @Rule
    public DbClearWithTestSMRule dbClearWithTestSMRule;
    @InjectFromRole
    private StateMachinesDAO stateMachinesDAO;

    @Before
    public void setup() {
    }

    @Test
    public void testFindById() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachineWithId();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        Assertions.assertThat((String)this.stateMachinesDAO.findById(standardTestMachine.getId()).getName()).isEqualTo((Object)standardTestMachine.getName());
        Assertions.assertThat((String)this.stateMachinesDAO.findById(standardTestMachine.getId()).getId()).isEqualTo((Object)standardTestMachine.getId());
    }

    @Test
    public void testUpdateStatus() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachineWithId();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        this.stateMachinesDAO.updateStatus(standardTestMachine.getId(), StateMachineStatus.cancelled);
        Assertions.assertThat((Comparable)this.stateMachinesDAO.findById(standardTestMachine.getId()).getStatus()).isEqualTo((Object)StateMachineStatus.cancelled);
    }
}

