/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.FluxRuntimeRole;
import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.dao.TestWorkflow;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateMachineStatus;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.eventscheduler.dao.EventSchedulerDao;
import com.flipkart.flux.eventscheduler.model.ScheduledEvent;
import com.flipkart.flux.guice.module.AkkaModule;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.ExecutionContainerModule;
import com.flipkart.flux.guice.module.ExecutionTaskModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.initializer.ExecutionOrderedComponentBooter;
import com.flipkart.flux.initializer.OrchestrationOrderedComponentBooter;
import com.flipkart.flux.module.DeploymentUnitTestModule;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.persistence.dao.iface.EventsDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.persistence.dao.iface.StatesDAO;
import com.flipkart.flux.persistence.dao.impl.ParallelScatterGatherQueryHelper;
import com.flipkart.flux.representation.StateMachinePersistenceService;
import com.flipkart.flux.resource.ExecutionApiResource;
import com.flipkart.flux.rule.DbClearRule;
import com.flipkart.flux.runner.GuiceJunit4Runner;
import com.flipkart.flux.runner.Modules;
import com.flipkart.flux.util.TestUtils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=GuiceJunit4Runner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, OrchestrationTaskModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, FluxClientInterceptorModule.class}, executionModules={FluxClientComponentModule.class, DeploymentUnitTestModule.class, AkkaModule.class, ExecutionTaskModule.class, ExecutionContainerModule.class, FluxClientInterceptorModule.class})
public class StateMachineResourceTest {
    public static final String STATE_MACHINE_RESOURCE_URL = "http://localhost:9998/api/machines";
    private static final String SLASH = "/";
    private static final String standardStateMachine = "standard-state-machine";
    @Rule
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    public DbClearRule dbClearRule;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    OrchestrationOrderedComponentBooter orchestrationOrderedComponentBooter;
    @InjectFromRole(value=FluxRuntimeRole.EXECUTION)
    ExecutionApiResource executionApiResource;
    @InjectFromRole(value=FluxRuntimeRole.EXECUTION)
    ExecutionOrderedComponentBooter executionOrderedComponentBooter;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    StateMachinePersistenceService stateMachinePersistenceService;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    private StateMachinesDAO stateMachinesDAO;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    private ParallelScatterGatherQueryHelper parallelScatterGatherQueryHelper;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    private StatesDAO statesDAO;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    private EventsDAO eventsDAO;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    private EventSchedulerDao eventSchedulerDao;
    @Mock
    private StateTraversalPathDAO stateTraversalPathDAO;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        this.objectMapper = new ObjectMapper();
        this.dbClearRule.explicitClearTables();
        try {
            Unirest.post((String)"http://localhost:9998/api/client-elb/create").queryString("clientId", (Object)"defaultElbId").queryString("clientElbUrl", (Object)"http://localhost:9997").asString();
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            Unirest.post((String)"http://localhost:9998/api/client-elb/delete").queryString("clientId", (Object)"defaultElbId").asString();
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testCreateStateMachine() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse response = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
        Assertions.assertThat((Iterable)this.parallelScatterGatherQueryHelper.findStateMachinesByName("test_state_machine")).hasSize(1);
        Thread.sleep(1000L);
        TestUtils.assertStateMachineEquality((StateMachine)this.parallelScatterGatherQueryHelper.findStateMachinesByName("test_state_machine").iterator().next(), TestUtils.getStandardTestMachine());
    }

    @Test
    public void testResetAttemptedNoOfRetries() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition_replayable.json"), (String)"UTF-8");
        HttpResponse response = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        String smId = (String)response.getBody();
        Event event = new Event("replayEvent", "java.lang.string", Event.EventStatus.invalid, smId, "someData", "");
        this.eventsDAO.updateEvent(smId, event);
        State state1 = this.stateMachinesDAO.findById(smId).getStates().stream().filter(e -> e.getName().equals("test_state2")).findFirst().orElse(null);
        State state = new State(state1.getVersion(), state1.getName(), state1.getDescription(), state1.getOnEntryHook(), state1.getTask(), state1.getOnExitHook(), state1.getDependencies(), state1.getRetryCount(), state1.getTimeout(), state1.getOutputEvent(), state1.getStatus(), state1.getRollbackStatus(), state1.getAttemptedNumOfRetries(), state1.getStateMachineId(), state1.getId(), Short.valueOf((short)5), Short.valueOf(state1.getMaxReplayableRetries()), state1.getReplayable());
        this.statesDAO.updateState(smId, state);
        Mockito.when((Object)this.stateTraversalPathDAO.findById(smId, state1.getId())).thenReturn(Optional.empty());
        HttpResponse resetRetriesResponse = Unirest.put((String)("http://localhost:9998/api/machines/" + smId + SLASH + state1.getId() + "/resetreplayretries")).asString();
        Assertions.assertThat((int)resetRetriesResponse.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
        Assertions.assertThat((Long)state1.getAttemptedNumOfRetries()).isEqualTo(0L);
        Assertions.assertThat((List)this.eventsDAO.findByEventNamesAndSMId(smId, Collections.singletonList("replayEvent"))).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsideline() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        TestWorkflow.shouldFail = true;
        try {
            String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
            HttpResponse eventPostResponse = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/events")).header("Content-Type", "application/json").body(eventJson).asString();
            Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
            Thread.sleep(9000L);
            String smId = (String)smCreationResponse.getBody();
            State state4 = this.stateMachinesDAO.findById(smId).getStates().stream().filter(e -> e.getName().equals("test_state4")).findFirst().orElse(null);
            Assertions.assertThat((Object)state4).isNotNull();
            Assertions.assertThat((Comparable)state4.getStatus()).isEqualTo((Object)Status.sidelined);
            TestWorkflow.shouldFail = false;
            HttpResponse unsidelineResponse = Unirest.put((String)("http://localhost:9998/api/machines/" + smId + SLASH + state4.getId() + "/unsideline")).asString();
            Assertions.assertThat((int)unsidelineResponse.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
            Thread.sleep(6000L);
            state4 = this.stateMachinesDAO.findById(smId).getStates().stream().filter(e -> e.getName().equals("test_state4")).findFirst().orElse(null);
            Assertions.assertThat((Object)state4).isNotNull();
            Assertions.assertThat((Comparable)state4.getStatus()).isEqualTo((Object)Status.completed);
        }
        finally {
            TestWorkflow.shouldFail = false;
        }
    }

    @Test
    public void testCreateStateMachine_shouldBombDueToDuplicateCorrelationId() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse response = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
        Assertions.assertThat((Iterable)this.parallelScatterGatherQueryHelper.findStateMachinesByName("test_state_machine")).hasSize(1);
        HttpResponse secondResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Assertions.assertThat((int)secondResponse.getStatus()).isEqualTo(Response.Status.CONFLICT.getStatusCode());
    }

    @Test
    public void testCreateStateMachine_shouldReturn5xxForNonDuplicateIdConstraintViolation() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition_broken.json"), (String)"UTF-8");
        HttpResponse response = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }

    @Test
    public void testPostEvent() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/events")).header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
        Thread.sleep(2000L);
        event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.triggered);
        Assertions.assertThat((Object)event).isEqualToIgnoringGivenFields((Object)TestUtils.getStandardTestEvent(), new String[]{"stateMachineInstanceId", "createdAt", "updatedAt"});
        event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event3", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.triggered);
        Thread.sleep(2000L);
        this.stateMachinesDAO.findById((String)smCreationResponse.getBody()).getStates().forEach(s -> System.out.println(s.toString()));
        boolean anyNotCompleted = this.stateMachinesDAO.findById((String)smCreationResponse.getBody()).getStates().stream().anyMatch(e -> !e.getStatus().equals((Object)Status.completed));
        Assertions.assertThat((boolean)anyNotCompleted).isFalse();
    }

    @Test
    public void testPostEvent_withCorrelationId() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/events?searchField=correlationId").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
        Thread.sleep(3000L);
        event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.triggered);
        Assertions.assertThat((Object)event).isEqualToIgnoringGivenFields((Object)TestUtils.getStandardTestEvent(), new String[]{"stateMachineInstanceId", "createdAt", "updatedAt"});
        event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event3", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.triggered);
        Thread.sleep(3000L);
        boolean anyNotCompleted = this.stateMachinesDAO.findById((String)smCreationResponse.getBody()).getStates().stream().anyMatch(e -> !e.getStatus().equals((Object)Status.completed));
        Assertions.assertThat((boolean)anyNotCompleted).isFalse();
    }

    @Test
    public void testPostEvent_againstNonExistingCorrelationId() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_2/context/events?searchField=correlationId").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void testPostScheduledEvent_withoutCorrelationIdTag() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/events?triggerTime=123").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
        HttpResponse eventPostResponseWithWrongTag = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/events?searchField=dummy&triggerTime=123").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponseWithWrongTag.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
    }

    @Test
    public void testPostScheduledEvent_withCorrelationId() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Assertions.assertThat((int)smCreationResponse.getStatus()).isEqualTo(201);
        Thread.sleep(100L);
        long triggerTime = System.currentTimeMillis() / 1000L + 1L;
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        Unirest.post((String)("http://localhost:9998/api/machines/magic_number_1/context/events?searchField=correlationId&triggerTime=" + triggerTime)).header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat(this.eventSchedulerDao.retrieveOldest(1).get(0)).isEqualTo((Object)new ScheduledEvent("magic_number_1", "event0", triggerTime, "{\"name\":\"event0\",\"type\":\"java.lang.String\",\"data\":\"42\",\"eventSource\":null,\"cancelled\":null}"));
        Thread.sleep(9000L);
        Assertions.assertThat((Comparable)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L)).getStatus()).isEqualTo((Object)Event.EventStatus.triggered);
        Assertions.assertThat((List)this.eventSchedulerDao.retrieveOldest(1)).hasSize(0);
    }

    @Test
    public void testPostScheduledEvent_withTriggerTimeInMilliSeconds() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Thread.sleep(100L);
        long triggerTime = System.currentTimeMillis();
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)("http://localhost:9998/api/machines/magic_number_1/context/events?searchField=correlationId&triggerTime=" + triggerTime)).header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((long)((ScheduledEvent)this.eventSchedulerDao.retrieveOldest(1).get(0)).getScheduledTime()).isEqualTo(triggerTime / 1000L);
    }

    @Test
    public void testPostEventUpdate_withNoEventData() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Thread.sleep(100L);
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("no_event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/eventupdate").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
    }

    @Test
    public void testPostInternalEventUpdate_withNoEventData() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Thread.sleep(100L);
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("no_event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/internaleventupdate").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventUpdate() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        TestWorkflow.shouldFail = true;
        try {
            String eventJson0 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("updated_event_data.json"), (String)"UTF-8");
            HttpResponse eventPostResponse0 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/eventupdate")).header("Content-Type", "application/json").body(eventJson0).asString();
            Assertions.assertThat((int)eventPostResponse0.getStatus()).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
            String eventJson1 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
            HttpResponse eventPostResponse1 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/events")).header("Content-Type", "application/json").body(eventJson1).asString();
            Assertions.assertThat((int)eventPostResponse1.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
            Thread.sleep(9000L);
            String smId = (String)smCreationResponse.getBody();
            State state4 = this.stateMachinesDAO.findById(smId).getStates().stream().filter(e -> e.getName().equals("test_state4")).findFirst().orElse(null);
            Assertions.assertThat((Object)state4).isNotNull();
            Assertions.assertThat((Comparable)state4.getStatus()).isEqualTo((Object)Status.sidelined);
            TestWorkflow.shouldFail = false;
            String eventJson2 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("updated_event_data.json"), (String)"UTF-8");
            HttpResponse eventPostResponse2 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/eventupdate")).header("Content-Type", "application/json").body(eventJson2).asString();
            Assertions.assertThat((int)eventPostResponse2.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
            Thread.sleep(2000L);
            state4 = this.stateMachinesDAO.findById(smId).getStates().stream().filter(e -> e.getName().equals("test_state4")).findFirst().orElse(null);
            Assertions.assertThat((Object)state4).isNotNull();
            Assertions.assertThat((Comparable)state4.getStatus()).isEqualTo((Object)Status.completed);
            Event event0 = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName(smId, "event0", Long.valueOf(0L));
            Assertions.assertThat((String)event0.getEventData()).isEqualTo((Object)"50");
        }
        finally {
            TestWorkflow.shouldFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInternalEventUpdate() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition_replayable.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        try {
            String smId = (String)smCreationResponse.getBody();
            State state2 = this.stateMachinesDAO.findById(smId).getStates().stream().filter(e -> e.getName().equals("test_state2")).findFirst().orElse(null);
            Assertions.assertThat((Object)state2).isNotNull();
            state2.setStatus(Status.completed);
            this.statesDAO.updateState(smId, state2);
            Assertions.assertThat((Comparable)state2.getStatus()).isEqualTo((Object)Status.completed);
            String eventJson1 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("internal_event_data.json"), (String)"UTF-8");
            HttpResponse eventPostResponse1 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/events")).header("Content-Type", "application/json").body(eventJson1).asString();
            Assertions.assertThat((int)eventPostResponse1.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
            Thread.sleep(4000L);
            String eventJson2 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("updated_internal_event_data.json"), (String)"UTF-8");
            HttpResponse eventPostResponse2 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/internaleventupdate")).header("Content-Type", "application/json").body(eventJson2).asString();
            Assertions.assertThat((int)eventPostResponse2.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
            Thread.sleep(2000L);
            state2 = this.stateMachinesDAO.findById(smId).getStates().stream().filter(e -> e.getName().equals("test_state2")).findFirst().orElse(null);
            Assertions.assertThat((Object)state2).isNotNull();
            Assertions.assertThat((Comparable)state2.getStatus()).isEqualTo((Object)Status.completed);
            Event event1 = this.eventsDAO.findValidEventBySMIdAndName(smId, "event1");
            Assertions.assertThat((String)event1.getEventData()).isEqualTo((Object)"50");
        }
        finally {
            TestWorkflow.shouldFail = false;
        }
    }

    @Test
    public void testInternalEventUpdateWithNonTriggeredEvent() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventBySMIdAndName((String)smCreationResponse.getBody(), "event1");
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        String eventJson0 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("updated_internal_event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse0 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/internaleventupdate")).header("Content-Type", "application/json").body(eventJson0).asString();
        Assertions.assertThat((int)eventPostResponse0.getStatus()).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
    }

    @Test
    public void testInternalEventUpdateNoReplayableState() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventBySMIdAndName((String)smCreationResponse.getBody(), "event1");
        String eventJson1 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("updated_internal_event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse1 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/internaleventupdate")).header("Content-Type", "application/json").body(eventJson1).asString();
        Assertions.assertThat((int)eventPostResponse1.getStatus()).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
    }

    @Test
    public void testInternalEventUpdateIncompleteStates() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition_replayable.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventBySMIdAndName((String)smCreationResponse.getBody(), "event1");
        String eventJson1 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("internal_event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse1 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/events")).header("Content-Type", "application/json").body(eventJson1).asString();
        String eventJson2 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("updated_internal_event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse2 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/internaleventupdate")).header("Content-Type", "application/json").body(eventJson2).asString();
        Assertions.assertThat((int)eventPostResponse2.getStatus()).isEqualTo(Response.Status.CONFLICT.getStatusCode());
    }

    private void testEventUpdate_IneligibleTaskStatus_Util(HttpResponse<String> smCreationResponse) throws Exception {
        String eventJson1 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        String eventJson2 = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("updated_event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse1 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/events")).header("Content-Type", "application/json").body(eventJson1).asString();
        HttpResponse eventPostResponse2 = Unirest.post((String)("http://localhost:9998/api/machines/" + (String)smCreationResponse.getBody() + "/context/eventupdate")).header("Content-Type", "application/json").body(eventJson2).asString();
        Assertions.assertThat((int)eventPostResponse2.getStatus()).isEqualTo(Response.Status.CONFLICT.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventUpdate_taskRunning() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        TestWorkflow.shouldFail = true;
        try {
            this.testEventUpdate_IneligibleTaskStatus_Util((HttpResponse<String>)smCreationResponse);
        }
        finally {
            TestWorkflow.shouldFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventUpdate_taskCompleted() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        TestWorkflow.shouldFail = false;
        try {
            this.testEventUpdate_IneligibleTaskStatus_Util((HttpResponse<String>)smCreationResponse);
        }
        finally {
            TestWorkflow.shouldFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventUpdate_taskCancelled() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        HttpResponse smCreationResponse = Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName((String)smCreationResponse.getBody(), "event0", Long.valueOf(0L));
        Assertions.assertThat((Comparable)event.getStatus()).isEqualTo((Object)Event.EventStatus.pending);
        TestWorkflow.shouldCancel = true;
        try {
            this.testEventUpdate_IneligibleTaskStatus_Util((HttpResponse<String>)smCreationResponse);
        }
        finally {
            TestWorkflow.shouldCancel = false;
        }
    }

    @Test
    public void testFsmGraphCreation() throws Exception {
        StateMachine stateMachine = this.stateMachinePersistenceService.createStateMachine(standardStateMachine, (StateMachineDefinition)this.objectMapper.readValue(this.getClass().getClassLoader().getResource("state_machine_definition_fork_join.json"), StateMachineDefinition.class));
        HttpResponse stringHttpResponse = Unirest.get((String)("http://localhost:9998/api/machines/" + stateMachine.getId() + "/fsmdata")).header("Content-Type", "application/json").asString();
        Assertions.assertThat((int)stringHttpResponse.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
    }

    @Test
    public void testGetErroredStates() throws Exception {
        StateMachine sm = this.stateMachinePersistenceService.createStateMachine(standardStateMachine, (StateMachineDefinition)this.objectMapper.readValue(this.getClass().getClassLoader().getResource("state_machine_definition.json"), StateMachineDefinition.class));
        ((State)sm.getStates().stream().findFirst().get()).setStatus(Status.errored);
        String firstSmId = "state-machine-1";
        sm.getStates().stream().forEach(state -> state.setStateMachineId(firstSmId));
        HashSet states = new HashSet();
        states.addAll(sm.getStates());
        Timestamp now = new Timestamp(System.currentTimeMillis() - 10000L);
        StateMachine firstSM = this.stateMachinesDAO.create(firstSmId, new StateMachine(firstSmId, sm.getVersion(), sm.getName(), sm.getDescription(), states, sm.getClientElbId()));
        String differentSMName = "state-machine-2";
        sm.getStates().stream().forEach(state -> state.setStateMachineId("state-machine-2"));
        states.clear();
        states.addAll(sm.getStates());
        StateMachine secondSM = this.stateMachinesDAO.create("state-machine-2", new StateMachine("state-machine-2", sm.getVersion(), sm.getName(), sm.getDescription(), states, sm.getClientElbId()));
        Timestamp future = new Timestamp(System.currentTimeMillis() + 3000L);
        HttpResponse stringHttpResponse = Unirest.get((String)("http://localhost:9998/api/machines/test_state_machine/states/errored?fromTime=" + now.toString().replace(' ', '+') + "&toTime=" + future.toString().replace(' ', '+'))).header("Content-Type", "application/json").asString();
        Assertions.assertThat((int)stringHttpResponse.getStatus()).isEqualTo(200);
        Assertions.assertThat((String)((String)stringHttpResponse.getBody())).isEqualTo((Object)("[[\"" + firstSM.getId() + "\"," + firstSM.getStates().stream().filter(e -> Status.errored.equals((Object)e.getStatus())).findFirst().get().getId() + ",\"errored\"],[\"" + secondSM.getId() + "\"," + secondSM.getStates().stream().filter(e -> Status.errored.equals((Object)e.getStatus())).findFirst().get().getId() + ",\"errored\"]]"));
    }

    @Test
    public void testCancelWorkflow() throws Exception {
        StateMachine sm = this.stateMachinePersistenceService.createStateMachine("magic_number_1", (StateMachineDefinition)this.objectMapper.readValue(this.getClass().getClassLoader().getResource("state_machine_definition.json"), StateMachineDefinition.class));
        String stateMachineId = sm.getId();
        State state = (State)sm.getStates().stream().findFirst().get();
        state.setStatus(Status.running);
        this.statesDAO.updateState(stateMachineId, state);
        Unirest.put((String)("http://localhost:9998/api/machines/" + stateMachineId + "/cancel")).asString();
        Thread.sleep(200L);
        StateMachine cancelledSM = this.stateMachinesDAO.findById(stateMachineId);
        Assertions.assertThat((Comparable)cancelledSM.getStatus()).isEqualTo((Object)StateMachineStatus.cancelled);
        int cancelledStateCount = 0;
        for (State st : cancelledSM.getStates()) {
            if (st.getStatus() != Status.cancelled) continue;
            ++cancelledStateCount;
        }
        Assertions.assertThat((int)cancelledStateCount).isEqualTo(3);
    }

    @Test
    public void testCancelWorkflow_withCorrelationId() throws Exception {
        StateMachine sm = this.stateMachinePersistenceService.createStateMachine("magic_number_1", (StateMachineDefinition)this.objectMapper.readValue(this.getClass().getClassLoader().getResource("state_machine_definition.json"), StateMachineDefinition.class));
        String stateMachineId = sm.getId();
        Unirest.put((String)("http://localhost:9998/api/machines/" + stateMachineId + "/cancel?searchField=correlationId")).asString();
        Thread.sleep(200L);
        StateMachine cancelledSM = this.stateMachinesDAO.findById(stateMachineId);
        Assertions.assertThat((Comparable)cancelledSM.getStatus()).isEqualTo((Object)StateMachineStatus.cancelled);
        cancelledSM.getStates().forEach(st -> Assertions.assertThat((Comparable)st.getStatus()).isEqualTo((Object)Status.cancelled));
    }

    @Test
    @Ignore(value="Feature no longer in use")
    public void shouldProxyEventToOldCluster() throws Exception {
        String stateMachineId = "some_random_machine_do_not_exist";
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse httpResponse = Unirest.post((String)"http://localhost:9998/api/machines/some_random_machine_do_not_exist/context/events").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)httpResponse.getStatus()).isEqualTo(202);
    }

    @Test
    @Ignore(value="Feature no longer in use")
    public void shouldProxyScheduledEventToOldCluster() throws Exception {
        String stateMachineId = "some_random_machine_do_not_exist";
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse httpResponse = Unirest.post((String)"http://localhost:9998/api/machines/some_random_machine_do_not_exist/context/events?triggerTime=0").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)httpResponse.getStatus()).isEqualTo(202);
    }

    @Test
    public void testRedriveTask_InvalidExecutionVersion() throws Exception {
        StateMachine sm = this.stateMachinePersistenceService.createStateMachine("magic_number_1", (StateMachineDefinition)this.objectMapper.readValue(this.getClass().getClassLoader().getResource("state_machine_definition.json"), StateMachineDefinition.class));
        String stateMachineId = sm.getId();
        HttpResponse httpResponse = Unirest.post((String)("http://localhost:9998/api/machines/redrivetask/" + stateMachineId + "/taskId/3/taskExecutionVersion/2")).asString();
        Assertions.assertThat((int)httpResponse.getStatus()).isEqualTo(Response.Status.ACCEPTED.getStatusCode());
    }

    @Test
    public void testPostReplayEvent_withNoEventData() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Thread.sleep(100L);
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("no_event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/replayevent").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
        Assertions.assertThat((String)((String)eventPostResponse.getBody())).isEqualTo((Object)"Event Data cannot be empty");
    }

    @Test
    public void testPostReplayEvent_withNoStateMachine() throws Exception {
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/replayevent").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void testPostReplayEvent_withCancelledStateMachine() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Thread.sleep(100L);
        Unirest.put((String)"http://localhost:9998/api/machines/magic_number_1/cancel").asString();
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/replayevent").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.PRECONDITION_FAILED.getStatusCode());
    }

    @Test
    public void testPostReplayEvent_withNoReplayEvent() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition.json"), (String)"UTF-8");
        Unirest.post((String)STATE_MACHINE_RESOURCE_URL).header("Content-Type", "application/json").body(stateMachineDefinitionJson).asString();
        Thread.sleep(100L);
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("event_data.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/replayevent").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
        Assertions.assertThat((String)((String)eventPostResponse.getBody())).isEqualTo((Object)"Triggered input event event0 doesn't exist as a replay event in database. Replay Event is identified by eventSource suffix flux_runtime_replay_internal");
    }

    @Test
    public void testUpdateEvent_withReplayableEventSourceRestriction() throws Exception {
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("replay_event_data_event_source_replayable.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/eventupdate").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
        Assertions.assertThat((String)((String)eventPostResponse.getBody())).isEqualTo((Object)"EventSource cannot contain flux_runtime_replay_internal as it is for internal use only. Modify Event Source and retry.");
    }

    @Test
    public void testPostReplayEvent_withReplayableEventSourceRestriction() throws Exception {
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("replay_event_data_event_source_replayable.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/replayevent").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
        Assertions.assertThat((String)((String)eventPostResponse.getBody())).isEqualTo((Object)"EventSource cannot contain flux_runtime_replay_internal as it is for internal use only. Modify Event Source and retry.");
    }

    @Test
    public void testPostExternalEvent_withReplayableEventSourceRestriction() throws Exception {
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("replay_event_data_event_source_replayable.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/events").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
        Assertions.assertThat((String)((String)eventPostResponse.getBody())).isEqualTo((Object)"EventSource cannot contain flux_runtime_replay_internal as it is for internal use only. Modify Event Source and retry.");
    }

    @Test
    public void testUpdateInternalEvent_withReplayableEventSourceRestriction() throws Exception {
        String eventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("replay_event_data_event_source_replayable.json"), (String)"UTF-8");
        HttpResponse eventPostResponse = Unirest.post((String)"http://localhost:9998/api/machines/magic_number_1/context/internaleventupdate").header("Content-Type", "application/json").body(eventJson).asString();
        Assertions.assertThat((int)eventPostResponse.getStatus()).isEqualTo(Response.Status.FORBIDDEN.getStatusCode());
        Assertions.assertThat((String)((String)eventPostResponse.getBody())).isEqualTo((Object)"EventSource cannot contain flux_runtime_replay_internal as it is for internal use only. Modify Event Source and retry.");
    }
}

