/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StatesDAO;
import com.flipkart.flux.rule.DbClearWithTestSMRule;
import com.flipkart.flux.runner.GuiceJunit4Runner;
import com.flipkart.flux.runner.Modules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GuiceJunit4Runner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, OrchestrationTaskModule.class, FluxClientInterceptorModule.class})
public class StatesDAOTest {
    @InjectFromRole
    @Rule
    public DbClearWithTestSMRule dbClearWithTestSMRule;
    @InjectFromRole
    StatesDAO statesDAO;
    @InjectFromRole
    StateMachinesDAO stateMachinesDAO;

    @Before
    public void setup() {
    }

    @Test
    public void testUpdateAttemptedNoOfReplayableRetries() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        this.statesDAO.incrementReplayableRetries(stateMachine.getId(), Long.valueOf(1L), Short.valueOf((short)(state.getAttemptedNumOfReplayableRetries() + 1)));
        this.statesDAO.incrementReplayableRetries(stateMachine.getId(), Long.valueOf(1L), Short.valueOf((short)(state.getAttemptedNumOfReplayableRetries() + 1)));
        this.statesDAO.updateReplayableRetries(stateMachine.getId(), Long.valueOf(1L), Short.valueOf((short)0));
        State state2 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        Assertions.assertThat((short)state2.getAttemptedNumOfReplayableRetries()).isEqualTo((short)0);
    }

    @Test
    public void testIncrementReplayableRetryCount() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state1 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        this.statesDAO.incrementReplayableRetries(stateMachine.getId(), Long.valueOf(1L), Short.valueOf((short)(state1.getAttemptedNumOfReplayableRetries() + 1)));
        State state2 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        Assertions.assertThat((int)(state1.getAttemptedNumOfReplayableRetries() + 1)).isEqualTo((int)state2.getAttemptedNumOfReplayableRetries());
    }

    @Test
    public void testIncrementRetryCount() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state1 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        this.statesDAO.incrementRetryCount(stateMachine.getId(), Long.valueOf(1L));
        State state2 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        Assertions.assertThat((long)(state1.getAttemptedNumOfRetries() + 1L)).isEqualTo((Object)state2.getAttemptedNumOfRetries());
    }

    @Test
    public void testUpdateExecutionVersion() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        this.statesDAO.updateExecutionVersion(stateMachine.getId(), Long.valueOf(1L), Long.valueOf(5L));
        State state1 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        Assertions.assertThat((Long)state1.getExecutionVersion()).isEqualTo(5L);
    }

    @Test
    public void testUpdateState() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state1 = new State(Long.valueOf(5L), "state1", "desc1", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_dummyTask", "com.flipkart.flux.dao.DummyOnExitHook", null, Long.valueOf(3L), Long.valueOf(60L), null, null, null, Long.valueOf(0L), "1", Long.valueOf(1L));
        this.statesDAO.updateState(stateMachine.getId(), state1);
        State state2 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        Assertions.assertThat((Long)state2.getVersion()).isEqualTo(5L);
    }

    @Test
    public void testFindStateByDependentEvent() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state1 = new State(Long.valueOf(2L), "state1", "desc1", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_dummyTask", "com.flipkart.flux.dao.DummyOnExitHook", Collections.singletonList("event1"), Long.valueOf(3L), Long.valueOf(60L), null, null, null, Long.valueOf(0L), "1", Long.valueOf(1L));
        this.statesDAO.updateState(stateMachine.getId(), state1);
        List stateList = this.statesDAO.findStatesByDependentEvent(stateMachine.getId(), "event1");
        Assertions.assertThat((String)((State)stateList.get(0)).getName()).isEqualTo((Object)"state1");
        Assertions.assertThat((Long)((State)stateList.get(0)).getId()).isEqualTo(1L);
    }

    @Test
    public void testFindStateByDependentReplayEvent() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state1 = new State(Long.valueOf(2L), "state1", "desc1", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_dummyTask", "com.flipkart.flux.dao.DummyOnExitHook", Collections.singletonList("ReplayEvent"), Long.valueOf(3L), Long.valueOf(60L), null, Status.completed, null, Long.valueOf(0L), "1", Long.valueOf(1L), Short.valueOf((short)5), Short.valueOf((short)2), Boolean.TRUE);
        this.statesDAO.updateState(stateMachine.getId(), state1);
        Long stateId = this.statesDAO.findStateIdByEventName(stateMachine.getId(), "ReplayEvent");
        Assertions.assertThat((Long)stateId).isEqualTo(1L);
    }

    @Test
    @Ignore(value="Need ShardId to test this test case")
    public void testFindStateByStatus() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state1 = new State(Long.valueOf(2L), "state1", "desc1", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_dummyTask", "com.flipkart.flux.dao.DummyOnExitHook", Collections.singletonList("ReplayEvent"), Long.valueOf(3L), Long.valueOf(60L), null, Status.completed, null, Long.valueOf(0L), "1", Long.valueOf(1L), Short.valueOf((short)5), Short.valueOf((short)2), Boolean.TRUE);
        this.statesDAO.updateState(stateMachine.getId(), state1);
        State state = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
    }

    @Test
    @Ignore(value="Need ShardId to test this test case")
    public void testFindErroredStates() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state1 = new State(Long.valueOf(2L), "state1", "desc1", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_dummyTask", "com.flipkart.flux.dao.DummyOnExitHook", Collections.singletonList("ReplayEvent"), Long.valueOf(3L), Long.valueOf(60L), null, Status.errored, null, Long.valueOf(0L), "1", Long.valueOf(1L), Short.valueOf((short)5), Short.valueOf((short)2), Boolean.TRUE);
        this.statesDAO.updateState(stateMachine.getId(), state1);
        State state = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
    }

    @Test
    public void testFindAllStatesForGivenStateIds() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state1 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        State state2 = this.statesDAO.findById(stateMachine.getId(), Long.valueOf(2L));
        List actualStates = this.statesDAO.findAllStatesForGivenStateIds(stateMachine.getId(), new ArrayList<Long>(Arrays.asList(1L, 2L)));
        Assertions.assertThat((actualStates.size() == 2 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)actualStates.containsAll(new ArrayList<State>(Arrays.asList(state1, state2)))).isTrue();
    }
}

