/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.flipkart.flux.api.ClientElbDefinition;
import com.flipkart.flux.domain.ClientElb;
import com.flipkart.flux.representation.ClientElbPersistenceService;
import com.flipkart.flux.resource.ClientElbResource;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientElbResourceTest {
    ClientElbPersistenceService clientElbPersistenceService = (ClientElbPersistenceService)Mockito.mock(ClientElbPersistenceService.class);
    ClientElbResource clientElbResource = new ClientElbResource(this.clientElbPersistenceService);

    @Test
    public void testCreateClientElb() {
        ClientElbDefinition clientElbDefinition = new ClientElbDefinition("id1", "http://127.0.0.1");
        ClientElb clientElb = new ClientElb("id1", "http://127.0.0.1");
        Mockito.when((Object)this.clientElbPersistenceService.persistClientElb("id1", clientElbDefinition)).thenReturn((Object)clientElb);
        Response response_1 = this.clientElbResource.createClientElb("id1", "http://127.0.0.1");
        Assertions.assertThat((int)response_1.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
        Response response_2 = this.clientElbResource.createClientElb("id1", null);
        Assertions.assertThat((int)response_2.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
        Response response_3 = this.clientElbResource.createClientElb("id1", "http:///127.0.0.1");
        Assertions.assertThat((int)response_3.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
        Response response_4 = this.clientElbResource.createClientElb(null, "http://127.0.0.1");
        Assertions.assertThat((int)response_4.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
        Response response_5 = this.clientElbResource.createClientElb("id1", "http://127.0.0.1/api");
        Assertions.assertThat((int)response_5.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
        ((ClientElbPersistenceService)Mockito.verify((Object)this.clientElbPersistenceService, (VerificationMode)Mockito.times((int)1))).persistClientElb("id1", clientElbDefinition);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.clientElbPersistenceService});
    }

    @Test
    public void testFindById() {
        Mockito.when((Object)this.clientElbPersistenceService.findByIdClientElb("id2")).thenReturn((Object)"http://127.0.0.1");
        Response response_1 = this.clientElbResource.findByIdClientElb(null);
        Assertions.assertThat((int)response_1.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
        Response response_2 = this.clientElbResource.findByIdClientElb("id2");
        Assertions.assertThat((int)response_2.getStatus()).isEqualTo(Response.Status.FOUND.getStatusCode());
        Mockito.when((Object)this.clientElbPersistenceService.findByIdClientElb("id2")).thenReturn(null);
        Response response_3 = this.clientElbResource.findByIdClientElb("id2");
        Assertions.assertThat((int)response_3.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
        ((ClientElbPersistenceService)Mockito.verify((Object)this.clientElbPersistenceService, (VerificationMode)Mockito.times((int)2))).findByIdClientElb("id2");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.clientElbPersistenceService});
    }
}

