/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.VersionedEventData;
import com.flipkart.flux.api.core.TaskExecutionMessage;
import com.flipkart.flux.controller.WorkFlowExecutionController;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.google.inject.name.Named;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;

public class TestUtils {
    @Inject
    @Named(value="")
    private static ObjectMapper objectMapper = new ObjectMapper();
    public static String routerName = "someRandomRouterName";

    public static StateMachine getStandardTestMachine() throws Exception {
        String stateMachineId = "magic_number_1";
        LinkedList<String> state3Events = new LinkedList<String>(){
            {
                this.add("event2");
                this.add("event3");
            }
        };
        LinkedList<String> state4Events = new LinkedList<String>(){
            {
                this.add("event0");
            }
        };
        final State state1 = new State(Long.valueOf(1L), "test_state1", "desc1", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", Collections.emptyList(), Long.valueOf(5L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event1", String.class)), Status.completed, null, Long.valueOf(0L), stateMachineId, Long.valueOf(1L));
        final State state2 = new State(Long.valueOf(1L), "test_state2", "desc2", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_java.lang.String_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", Collections.singletonList("event1"), Long.valueOf(3L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event2", String.class)), Status.completed, null, Long.valueOf(0L), stateMachineId, Long.valueOf(2L));
        final State state3 = new State(Long.valueOf(1L), "test_state3", "desc3", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_void_java.lang.String_java.lang.Integer_version1", "com.flipkart.flux.dao.DummyOnExitHook", (List)state3Events, Long.valueOf(3L), Long.valueOf(100L), null, Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(3L));
        final State state4 = new State(Long.valueOf(1L), "test_state4", "desc4", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_dummyTask_java.lang.Integer_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", (List)state4Events, Long.valueOf(1L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event3", Integer.class)), Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(4L));
        HashSet<State> states = new HashSet<State>(){
            {
                this.add(state1);
                this.add(state2);
                this.add(state3);
                this.add(state4);
            }
        };
        return new StateMachine(stateMachineId, Long.valueOf(1L), "test_state_machine", "desc", (Set)states, "defaultElbId");
    }

    public static StateMachine getStandardTestMachineWithId() throws Exception {
        String stateMachineId = "standard-machine";
        LinkedList<String> state3Events = new LinkedList<String>(){
            {
                this.add("event2");
                this.add("event3");
            }
        };
        LinkedList<String> state4Events = new LinkedList<String>(){
            {
                this.add("event0");
            }
        };
        final State state1 = new State(Long.valueOf(1L), "test_state1", "desc1", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", Collections.emptyList(), Long.valueOf(5L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event1", String.class)), Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(1L));
        final State state2 = new State(Long.valueOf(1L), "test_state2", "desc2", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_java.lang.String_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", Collections.singletonList("event1"), Long.valueOf(3L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event2", String.class)), Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(2L));
        final State state3 = new State(Long.valueOf(1L), "test_state3", "desc3", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_void_java.lang.String_java.lang.Integer_version1", "com.flipkart.flux.dao.DummyOnExitHook", (List)state3Events, Long.valueOf(3L), Long.valueOf(100L), null, Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(3L));
        final State state4 = new State(Long.valueOf(1L), "test_state4", "desc4", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_dummyTask_java.lang.Integer_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", (List)state4Events, Long.valueOf(1L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event3", Integer.class)), Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(4L));
        TestUtils.setProperty(state1, "id", 1L);
        TestUtils.setProperty(state2, "id", 2L);
        TestUtils.setProperty(state3, "id", 3L);
        TestUtils.setProperty(state4, "id", 4L);
        HashSet<State> states = new HashSet<State>(){
            {
                this.add(state1);
                this.add(state2);
                this.add(state3);
                this.add(state4);
            }
        };
        StateMachine stateMachine = new StateMachine(stateMachineId, Long.valueOf(1L), "test_state_machine", "desc", (Set)states, "defaultElbId");
        return stateMachine;
    }

    public static StateMachine getStandardTestMachineWithReplayableState() throws Exception {
        String stateMachineId = "standard-machine-replayable";
        LinkedList<String> state3Events = new LinkedList<String>(){
            {
                this.add("event2");
                this.add("event3");
            }
        };
        LinkedList<String> state4Events = new LinkedList<String>(){
            {
                this.add("event0");
            }
        };
        final State state1 = new State(Long.valueOf(1L), "test_state1", "desc1", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", Collections.emptyList(), Long.valueOf(5L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event1", String.class)), Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(1L), Boolean.TRUE);
        final State state2 = new State(Long.valueOf(1L), "test_state2", "desc2", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_java.lang.String_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", Collections.singletonList("event1"), Long.valueOf(3L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event2", String.class)), Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(2L));
        final State state3 = new State(Long.valueOf(1L), "test_state3", "desc3", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_testTask_void_java.lang.String_java.lang.Integer_version1", "com.flipkart.flux.dao.DummyOnExitHook", (List)state3Events, Long.valueOf(3L), Long.valueOf(100L), null, Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(3L));
        final State state4 = new State(Long.valueOf(1L), "test_state4", "desc4", "com.flipkart.flux.dao.DummyOnEntryHook", "com.flipkart.flux.dao.TestWorkflow_dummyTask_java.lang.Integer_java.lang.String_version1", "com.flipkart.flux.dao.DummyOnExitHook", (List)state4Events, Long.valueOf(1L), Long.valueOf(100L), TestUtils.toStr(TestUtils.getOutputEvent("event3", Integer.class)), Status.initialized, null, Long.valueOf(0L), stateMachineId, Long.valueOf(4L), Boolean.TRUE);
        TestUtils.setProperty(state1, "id", 1L);
        TestUtils.setProperty(state2, "id", 2L);
        TestUtils.setProperty(state3, "id", 3L);
        TestUtils.setProperty(state4, "id", 4L);
        HashSet<State> states = new HashSet<State>(){
            {
                this.add(state1);
                this.add(state2);
                this.add(state3);
                this.add(state4);
            }
        };
        StateMachine stateMachine = new StateMachine(stateMachineId, Long.valueOf(1L), "test_state_machine", "desc", (Set)states, "defaultElbId");
        return stateMachine;
    }

    public static EventDefinition getOutputEvent(String name, Class clazz) {
        return new EventDefinition(name, clazz.getCanonicalName());
    }

    public static void assertStateMachineEquality(StateMachine actual, StateMachine expected) {
        Assertions.assertThat((Object)actual).isEqualToIgnoringGivenFields((Object)expected, new String[]{"states", "context", "createdAt", "updatedAt", "id"});
        Assertions.assertThat((int)actual.getStates().size()).isEqualTo(expected.getStates().size());
        actual.getStates().forEach(actualState -> expected.getStates().forEach(expectedState -> {
            if (actualState.getName() == expected.getName()) {
                TestUtils.assertStateEquality(actualState, expectedState);
            }
        }));
    }

    public static void assertStateEquality(State actual, State expected) {
        Assertions.assertThat((Object)actual).isEqualToIgnoringGivenFields((Object)expected, new String[]{"id", "createdAt", "updatedAt", "stateMachineId"});
    }

    public static Event getStandardTestEvent() throws JsonProcessingException {
        return new Event("event0", "java.lang.String", Event.EventStatus.triggered, null, "42", null);
    }

    public static String toStr(Object obj) throws Exception {
        return objectMapper.writeValueAsString(obj);
    }

    public static boolean setProperty(Object object, String fieldName, Object fieldValue) {
        Class<?> clazz = object.getClass();
        while (clazz != null) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(object, fieldValue);
                boolean bl = true;
                return bl;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (field == null) continue;
                field.setAccessible(false);
            }
        }
        return false;
    }

    public static TaskExecutionMessage getStandardTaskExecutionMessage() throws Exception {
        VersionedEventData[] expectedEvents = new VersionedEventData[]{new VersionedEventData("event0", "java.lang.String", "42", "runtime")};
        StateMachine sm = TestUtils.getStandardTestMachine();
        State state = sm.getStates().stream().filter(s -> s.getId() == 4L).findFirst().orElse(null);
        TaskExecutionMessage msg = new TaskExecutionMessage();
        msg.setRouterName(WorkFlowExecutionController.getRouterName((String)state.getTask()));
        msg.setAkkaMessage(new TaskAndEvents(state.getName(), state.getTask(), state.getId(), expectedEvents, state.getStateMachineId(), "test_state_machine", state.getOutputEvent(), state.getRetryCount().longValue()));
        return msg;
    }
}

