/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.codahale.metrics.jmx.JmxReporter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.flipkart.flux.filter.CORSFilter;
import com.flipkart.flux.resource.ClientElbResource;
import com.flipkart.flux.resource.StateMachineResource;
import com.flipkart.flux.resource.StatusResource;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class OrchestratorContainerModule
extends AbstractModule {
    public void configure() {
    }

    @Named(value="APIJettyServer")
    @Provides
    @Singleton
    Server getAPIJettyServer(@Named(value="Api.service.port") int port, @Named(value="APIResourceConfig") ResourceConfig resourceConfig, @Named(value="Api.service.acceptors") int acceptorThreads, @Named(value="Api.service.selectors") int selectorThreads, @Named(value="Api.service.workers") int maxWorkerThreads, ObjectMapper objectMapper, MetricRegistry metricRegistry) throws URISyntaxException, UnknownHostException {
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(objectMapper);
        resourceConfig.register((Object)provider);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxWorkerThreads);
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector http = new ServerConnector(server, acceptorThreads, selectorThreads);
        http.setPort(port);
        server.addConnector((Connector)http);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/*");
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(resourceConfig));
        context.addServlet(servlet, "/*");
        InstrumentedHandler handler = new InstrumentedHandler(metricRegistry);
        handler.setName("Orchestration-Runtime-Metrics-");
        handler.setHandler((Handler)context);
        server.setHandler((Handler)handler);
        server.setStopAtShutdown(true);
        return server;
    }

    @Named(value="APIResourceConfig")
    @Singleton
    @Provides
    public ResourceConfig getAPIResourceConfig(StateMachineResource stateMachineResource, StatusResource statusResource, ClientElbResource clientElbResource, MetricRegistry metricRegistry) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)new InstrumentedResourceMethodApplicationListener(metricRegistry));
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
        resourceConfig.register((Object)stateMachineResource);
        resourceConfig.register((Object)statusResource);
        resourceConfig.register((Object)clientElbResource);
        resourceConfig.register(CORSFilter.class);
        jmxReporter.start();
        return resourceConfig;
    }
}

