/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.representation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.AuditEvent;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateDefinition;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.constant.RuntimeConstants;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Context;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.exception.CreateStateMachineException;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.persistence.dao.iface.AuditDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.representation.EventPersistenceService;
import com.flipkart.flux.representation.IllegalRepresentationException;
import com.flipkart.flux.utils.SearchUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class StateMachinePersistenceService {
    private final ObjectMapper objectMapper;
    private StateMachinesDAO stateMachinesDAO;
    private AuditDAO auditDAO;
    private StateTraversalPathDAO stateTraversalPathDAO;
    private EventPersistenceService eventPersistenceService;
    private Integer maxRetryCount;
    private static Logger logger = LogManager.getLogger(StateMachinePersistenceService.class);

    @Inject
    public StateMachinePersistenceService(StateMachinesDAO stateMachinesDAO, AuditDAO auditDAO, StateTraversalPathDAO stateTraversalPathDAO, EventPersistenceService eventPersistenceService, @Named(value="task.maxTaskRetryCount") Integer maxRetryCount) {
        this.stateMachinesDAO = stateMachinesDAO;
        this.auditDAO = auditDAO;
        this.stateTraversalPathDAO = stateTraversalPathDAO;
        this.eventPersistenceService = eventPersistenceService;
        this.maxRetryCount = maxRetryCount;
        this.objectMapper = new ObjectMapper();
    }

    public static StateMachineDefinition validateReplayableStates(StateMachineDefinition stateMachineDefinition) throws CreateStateMachineException {
        Set setOfStates = stateMachineDefinition.getStates();
        HashMap<String, Integer> replayEventCount = new HashMap<String, Integer>();
        HashMap<String, Integer> replayableStates = new HashMap<String, Integer>();
        for (StateDefinition state : setOfStates) {
            if (!state.isReplayable() || state.getDependencies().isEmpty()) continue;
            replayableStates.putIfAbsent(state.getName(), 0);
            List dependentEvents = state.getDependencies();
            for (EventDefinition dependentEvent : dependentEvents) {
                if (dependentEvent.getEventSource() == null || !dependentEvent.getEventSource().toLowerCase().contains("flux_runtime_replay_internal".toLowerCase())) continue;
                replayableStates.put(state.getName(), (Integer)replayableStates.get(state.getName()) + 1);
                if (replayEventCount.get(dependentEvent.getName()) != null) {
                    replayEventCount.put(dependentEvent.getName(), (Integer)replayEventCount.get(dependentEvent.getName()) + 1);
                    continue;
                }
                replayEventCount.put(dependentEvent.getName(), 1);
            }
            if (replayableStates.get(state.getName()) == null || (Integer)replayableStates.get(state.getName()) <= 1) continue;
            logger.error("There are 2 or more dependent replay events. To make state: {} as replayable, retry submitting workflow with only one dependent event as replayable.", (Object)state.getName(), (Object)state.getName());
            throw new CreateStateMachineException("A single state cannot have multiple dependent replay events.");
        }
        if (!replayEventCount.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList()).isEmpty()) {
            throw new CreateStateMachineException("Multiple states cannot have same Replay Event as dependency.");
        }
        return stateMachineDefinition;
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public StateMachine createStateMachine(String stateMachineId, StateMachineDefinition stateMachineDefinition) throws CreateStateMachineException {
        StateMachinePersistenceService.validateReplayableStates(stateMachineDefinition);
        Map eventDataMap = stateMachineDefinition.getEventDataMap();
        Set<Event> allEvents = this.createAllEvents(eventDataMap);
        Set stateDefinitions = stateMachineDefinition.getStates();
        HashSet<State> states = new HashSet<State>();
        AtomicInteger stateId = new AtomicInteger(1);
        for (StateDefinition stateDefinition : stateDefinitions) {
            State state = this.convertStateDefinitionToState(stateDefinition, stateMachineId, stateId.longValue());
            states.add(state);
            stateId.incrementAndGet();
        }
        StateMachine stateMachine = new StateMachine(stateMachineId, stateMachineDefinition.getVersion(), stateMachineDefinition.getName(), stateMachineDefinition.getDescription(), states, stateMachineDefinition.getClientElbId());
        this.stateMachinesDAO.create(stateMachineId, stateMachine);
        for (Event event : allEvents) {
            event.setStateMachineInstanceId(stateMachine.getId());
            this.eventPersistenceService.persistEvent(event);
        }
        for (State state : stateMachine.getStates()) {
            this.auditDAO.create(stateMachine.getId(), new AuditRecord(stateMachine.getId(), state.getId(), Long.valueOf(0L), Status.initialized, null, null, Long.valueOf(0L), this.getDependentEvents(state.getDependencies(), 0L)));
        }
        return stateMachine;
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Map<Long, List<Long>> createAndPersistStateTraversal(String stateMachineId, StateMachine stateMachine, Context context) throws RuntimeException {
        HashMap<Long, List<Long>> replayStateTraversalPath = new HashMap<Long, List<Long>>();
        SearchUtil searchUtil = new SearchUtil();
        Set<Long> replayableStateIds = this.filterReplayableStates(stateMachine.getStates());
        for (Long replayableStateId : replayableStateIds) {
            List nextDependentStateIds = searchUtil.findStatesInTraversalPath(context, stateMachine, replayableStateId);
            replayStateTraversalPath.put(replayableStateId, nextDependentStateIds);
            this.stateTraversalPathDAO.create(stateMachineId, new StateTraversalPath(stateMachineId, replayableStateId, (List)replayStateTraversalPath.get(replayableStateId)));
        }
        return replayStateTraversalPath;
    }

    private Set<Long> filterReplayableStates(Set<State> states) {
        HashSet<Long> replayableStateIds = new HashSet<Long>();
        for (State state : states) {
            if (!state.getReplayable().booleanValue()) continue;
            replayableStateIds.add(state.getId());
        }
        return replayableStateIds;
    }

    private Set<Event> createAllEvents(Map<EventDefinition, EventData> eventDataMap) {
        HashSet<Event> allEvents = new HashSet<Event>();
        for (Map.Entry<EventDefinition, EventData> currentEventDefinitionAndData : eventDataMap.entrySet()) {
            Event currentEvent = this.eventPersistenceService.convertEventDefinitionToEvent(currentEventDefinitionAndData.getKey());
            if (currentEventDefinitionAndData.getValue() != null) {
                currentEvent.setEventData(currentEventDefinitionAndData.getValue().getData());
                currentEvent.setEventSource(currentEventDefinitionAndData.getValue().getEventSource());
                currentEvent.setStatus(Event.EventStatus.triggered);
            }
            allEvents.add(currentEvent);
        }
        return allEvents;
    }

    private State convertStateDefinitionToState(StateDefinition stateDefinition, String stateMachineId, Long id) {
        try {
            List eventDefinitions = stateDefinition.getDependencies();
            LinkedList<String> events = new LinkedList<String>();
            if (eventDefinitions != null) {
                for (EventDefinition e : eventDefinitions) {
                    events.add(e.getName());
                }
            }
            if (stateDefinition.getMaxReplayableRetries() != null && stateDefinition.getMaxReplayableRetries() > RuntimeConstants.MAX_REPLAYABLE_RETRIES) {
                stateDefinition.setMaxReplayableRetries(RuntimeConstants.MAX_REPLAYABLE_RETRIES);
                logger.warn("MaxReplayableRetries has been reset to {} for state {}. Value provided by user was higher than threshold", (Object)RuntimeConstants.MAX_REPLAYABLE_RETRIES, (Object)stateDefinition.getName());
            }
            State state = new State(stateDefinition.getVersion(), stateDefinition.getName(), stateDefinition.getDescription(), stateDefinition.getOnEntryHook(), stateDefinition.getTask(), stateDefinition.getOnExitHook(), events, Long.valueOf(Math.min(stateDefinition.getRetryCount(), (long)this.maxRetryCount.intValue())), stateDefinition.getTimeout(), stateDefinition.getOutputEvent() != null ? this.objectMapper.writeValueAsString((Object)stateDefinition.getOutputEvent()) : null, Status.initialized, null, Long.valueOf(0L), stateMachineId, id, Short.valueOf(stateDefinition.getMaxReplayableRetries() != null ? stateDefinition.getMaxReplayableRetries().shortValue() : RuntimeConstants.MAX_REPLAYABLE_RETRIES.shortValue()), Short.valueOf((short)0), Boolean.valueOf(stateDefinition.isReplayable()));
            return state;
        }
        catch (Exception e) {
            throw new IllegalRepresentationException("Unable to create state domain object", e);
        }
    }

    private String getDependentEvents(List<String> stateDependentEventNames, Long eventExecutionVersion) {
        LinkedList<AuditEvent> dependentEvents = new LinkedList<AuditEvent>();
        for (String dependentEventName : stateDependentEventNames) {
            dependentEvents.add(new AuditEvent(dependentEventName, eventExecutionVersion));
        }
        return ((Object)dependentEvents).toString();
    }
}

