/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;

public class FsmGraphEdge {
    @JsonProperty
    private String label;
    @JsonProperty
    private Set<Long> incidentOn;
    @JsonProperty
    private String status;
    @JsonProperty
    private String source;
    @JsonProperty
    private String eventData;
    @JsonProperty
    private Timestamp updatedAt;

    FsmGraphEdge() {
        this(null, null, null, null, null);
    }

    public FsmGraphEdge(String label, String status, String source, String eventData, Timestamp updatedAt) {
        this(new HashSet<Long>(), label, status, source, eventData, updatedAt);
    }

    public FsmGraphEdge(Set<Long> incidentOn, String label, String status, String source, String eventData, Timestamp updatedAt) {
        this.incidentOn = incidentOn;
        this.label = label == null ? "" : label.trim();
        this.status = status;
        this.source = source == null ? "" : source.trim();
        this.eventData = eventData;
        this.updatedAt = updatedAt;
    }

    @JsonIgnore
    public void addOutgoingVertex(Long vertexId) {
        this.incidentOn.add(vertexId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FsmGraphEdge that = (FsmGraphEdge)o;
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.incidentOn != null ? !this.incidentOn.equals(that.incidentOn) : that.incidentOn != null) {
            return false;
        }
        return !(this.status == null ? that.status != null : !this.status.equals(that.status));
    }

    public int hashCode() {
        int result = this.label != null ? this.label.hashCode() : 0;
        result = 31 * result + (this.incidentOn != null ? this.incidentOn.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FsmGraphEdge{incidentOn=" + this.incidentOn + ", label='" + this.label + '\'' + ", status='" + this.status + '\'' + '}';
    }
}

