/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.eventscheduler.dao;

import com.flipkart.flux.eventscheduler.model.ScheduledEvent;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Order;

@Singleton
public class EventSchedulerDao {
    private SessionFactoryContext sessionFactoryContext;

    @Inject
    public EventSchedulerDao(@Named(value="schedulerSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        this.sessionFactoryContext = sessionFactoryContext;
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public void save(ScheduledEvent scheduledEvent) {
        this.currentSession().saveOrUpdate((Object)scheduledEvent);
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public void delete(String correlationId, String eventName) {
        Query deleteQuery = this.currentSession().createQuery("delete ScheduledEvent s where s.correlationId=:correlationId and s.eventName=:eventName");
        deleteQuery.setString("correlationId", correlationId);
        deleteQuery.setString("eventName", eventName);
        deleteQuery.executeUpdate();
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public List<ScheduledEvent> retrieveOldest(int rowCount) {
        return this.currentSession().createCriteria(ScheduledEvent.class).addOrder(Order.asc((String)"scheduledTime")).setMaxResults(rowCount).list();
    }

    private Session currentSession() {
        return this.sessionFactoryContext.getThreadLocalSession();
    }
}

