/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.eventscheduler.service;

import com.codahale.metrics.InstrumentedScheduledExecutorService;
import com.codahale.metrics.SharedMetricRegistries;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.eventscheduler.dao.EventSchedulerDao;
import com.flipkart.flux.eventscheduler.model.ScheduledEvent;
import com.flipkart.flux.task.eventscheduler.EventSchedulerRegistry;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class EventSchedulerService {
    private static final Logger logger = LogManager.getLogger(EventSchedulerService.class);
    private static final String scheduledExectorSvcName = "event-scheduler-batch-read-executor-svc";
    private Integer batchReadInterval;
    private Integer batchSize;
    private Long initialDelay = 10000L;
    private ScheduledFuture<?> scheduledFuture;
    private EventSchedulerDao eventSchedulerDao;
    private final EventSchedulerRegistry eventSchedulerRegistry;
    private final InstrumentedScheduledExecutorService scheduledExecutorService;
    private ObjectMapper objectMapper;

    @Inject
    public EventSchedulerService(EventSchedulerDao eventSchedulerDao, EventSchedulerRegistry eventSchedulerRegistry, @Named(value="eventScheduler.batchRead.intervalms") Integer batchReadInterval, @Named(value="eventScheduler.batchRead.batchSize") Integer batchSize, ObjectMapper objectMapper) {
        this.eventSchedulerDao = eventSchedulerDao;
        this.eventSchedulerRegistry = eventSchedulerRegistry;
        this.batchReadInterval = batchReadInterval;
        this.batchSize = batchSize;
        this.objectMapper = objectMapper;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.setRemoveOnCancelPolicy(true);
        this.scheduledExecutorService = new InstrumentedScheduledExecutorService(Executors.unconfigurableScheduledExecutorService(executor), SharedMetricRegistries.getOrCreate((String)"mainMetricRegistry"), scheduledExectorSvcName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        EventSchedulerService eventSchedulerService = this;
        synchronized (eventSchedulerService) {
            if (this.scheduledFuture == null || this.scheduledFuture.isDone()) {
                this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
                    try {
                        this.triggerEvents();
                    }
                    catch (Exception e) {
                        logger.error("Error while running triggerEvents", (Throwable)e);
                    }
                }, this.initialDelay.longValue(), (long)this.batchReadInterval.intValue(), TimeUnit.MILLISECONDS);
                logger.info("EventSchedulerService started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        EventSchedulerService eventSchedulerService = this;
        synchronized (eventSchedulerService) {
            this.scheduledFuture.cancel(false);
            logger.info("EventSchedulerService stopped");
        }
    }

    public Boolean isRunning() {
        return this.scheduledFuture != null && !this.scheduledFuture.isDone();
    }

    private void triggerEvents() {
        List<ScheduledEvent> events;
        long now = System.currentTimeMillis() / 1000L;
        do {
            events = this.eventSchedulerDao.retrieveOldest(this.batchSize);
            events.stream().filter(e -> e.getScheduledTime() <= now).forEach(e -> {
                try {
                    EventData eventData = (EventData)this.objectMapper.readValue(e.getEventData(), EventData.class);
                    this.eventSchedulerRegistry.triggerEvent(e.getEventName(), (Object)eventData.getData(), e.getCorrelationId(), eventData.getEventSource());
                    this.eventSchedulerRegistry.deregisterEvent(e.getCorrelationId(), e.getEventName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        } while (events.size() == this.batchSize.intValue() && events.get(events.size() - 1).getScheduledTime() <= now);
    }

    public void setInitialDelay(Long initialDelay) {
        this.initialDelay = initialDelay;
    }
}

