/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.redriver.model;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

@Entity
@Table(name="ScheduledMessages")
@IdClass(value=ScheduledMessagePK.class)
public class ScheduledMessage
implements Serializable {
    @Id
    private Long taskId;
    @Id
    private String stateMachineId;
    @Id
    private Long executionVersion;
    private long scheduledTime;

    ScheduledMessage() {
    }

    public ScheduledMessage(Long taskId, String stateMachineId, Long scheduledTime, Long executionVersion) {
        this();
        this.taskId = taskId;
        this.stateMachineId = stateMachineId;
        this.scheduledTime = scheduledTime;
        this.executionVersion = executionVersion;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public String getStateMachineId() {
        return this.stateMachineId;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public long getExecutionVersion() {
        return this.executionVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledMessage)) {
            return false;
        }
        ScheduledMessage that = (ScheduledMessage)o;
        if (this.getScheduledTime() != that.getScheduledTime()) {
            return false;
        }
        if (!this.getTaskId().equals(that.getTaskId())) {
            return false;
        }
        if (this.executionVersion.longValue() != that.getExecutionVersion()) {
            return false;
        }
        return this.getStateMachineId().equals(that.getStateMachineId());
    }

    public int hashCode() {
        int result = this.getTaskId().hashCode();
        result = 31 * result + this.getStateMachineId().hashCode();
        result = 31 * result + (int)(this.getScheduledTime() ^ this.getScheduledTime() >>> 32);
        result = 31 * result + this.executionVersion.hashCode();
        return result;
    }

    public String toString() {
        return "ScheduledMessage{taskId=" + this.taskId + ", stateMachineId='" + this.stateMachineId + '\'' + ", scheduledTime=" + this.scheduledTime + ", executionVersion=" + this.executionVersion + '}';
    }

    static class ScheduledMessagePK
    implements Serializable {
        private Long taskId;
        private String stateMachineId;
        private Long executionVersion;

        public ScheduledMessagePK() {
        }

        public ScheduledMessagePK(Long taskId, String stateMachineId, Long executionVersion) {
            this.taskId = taskId;
            this.stateMachineId = stateMachineId;
            this.executionVersion = executionVersion;
        }

        public Long getTaskId() {
            return this.taskId;
        }

        public void setTaskId(Long taskId) {
            this.taskId = taskId;
        }

        public String getStateMachineId() {
            return this.stateMachineId;
        }

        public void setStateMachineId(String stateMachineId) {
            this.stateMachineId = stateMachineId;
        }

        public Long getExecutionVersion() {
            return this.executionVersion;
        }

        public void setExecutionVersion(Long executionVersion) {
            this.executionVersion = executionVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScheduledMessagePK)) {
                return false;
            }
            ScheduledMessagePK that = (ScheduledMessagePK)o;
            if (!this.getTaskId().equals(that.getTaskId())) {
                return false;
            }
            if (!this.getExecutionVersion().equals(that.getExecutionVersion())) {
                return false;
            }
            return this.getStateMachineId().equals(that.getStateMachineId());
        }

        public int hashCode() {
            int result = this.getTaskId().hashCode();
            result = 31 * result + this.getStateMachineId().hashCode();
            result = 31 * result + this.getExecutionVersion().hashCode();
            return result;
        }
    }
}

