/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.eventscheduler.model;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

@Entity
@Table(name="ScheduledEvents")
@IdClass(value=ScheduledEventPK.class)
public class ScheduledEvent
implements Serializable {
    @Id
    private String correlationId;
    @Id
    private String eventName;
    private long scheduledTime;
    private String eventData;

    public ScheduledEvent() {
    }

    public ScheduledEvent(String correlationId, String eventName, long scheduledTime, String eventData) {
        this.correlationId = correlationId;
        this.eventName = eventName;
        this.scheduledTime = scheduledTime;
        this.eventData = eventData;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public String getEventData() {
        return this.eventData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledEvent)) {
            return false;
        }
        ScheduledEvent that = (ScheduledEvent)o;
        if (this.scheduledTime != that.scheduledTime) {
            return false;
        }
        if (!this.correlationId.equals(that.correlationId)) {
            return false;
        }
        if (!this.eventData.equals(that.eventData)) {
            return false;
        }
        return this.eventName.equals(that.eventName);
    }

    public int hashCode() {
        int result = this.correlationId.hashCode();
        result = 31 * result + this.eventName.hashCode();
        result = 31 * result + (int)(this.scheduledTime ^ this.scheduledTime >>> 32);
        result = 31 * result + this.eventData.hashCode();
        return result;
    }

    static class ScheduledEventPK
    implements Serializable {
        private String correlationId;
        private String eventName;

        public ScheduledEventPK() {
        }

        public ScheduledEventPK(String correlationId, String eventName) {
            this.correlationId = correlationId;
            this.eventName = eventName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScheduledEventPK)) {
                return false;
            }
            ScheduledEventPK that = (ScheduledEventPK)o;
            if (!this.correlationId.equals(that.correlationId)) {
                return false;
            }
            return this.eventName.equals(that.eventName);
        }

        public int hashCode() {
            int result = this.correlationId.hashCode();
            result = 31 * result + this.eventName.hashCode();
            return result;
        }
    }
}

