/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.redriver.dao;

import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.flux.redriver.model.SmIdAndTaskIdWithExecutionVersion;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

@Singleton
public class MessageDao {
    private SessionFactoryContext sessionFactoryContext;

    @Inject
    public MessageDao(@Named(value="schedulerSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        this.sessionFactoryContext = sessionFactoryContext;
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public void save(ScheduledMessage scheduledMessage) {
        this.currentSession().saveOrUpdate((Object)scheduledMessage);
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public int bulkInsertOrUpdate(List<ScheduledMessage> messages) {
        StringBuilder query = new StringBuilder("insert into ScheduledMessages ( stateMachineId , taskId , scheduledTime, executionVersion )  values ");
        messages.forEach(scheduledMessage -> {
            query.append("( '").append(scheduledMessage.getStateMachineId()).append("' , ");
            query.append(scheduledMessage.getTaskId()).append(" , ");
            query.append(scheduledMessage.getScheduledTime()).append(",");
            query.append(scheduledMessage.getExecutionVersion()).append("), ");
        });
        query.deleteCharAt(query.length() - 1);
        query.setCharAt(query.length() - 1, ' ');
        query.append("on duplicate key update scheduledTime = values(scheduledTime)");
        NativeQuery insertOrUpdateQuery = this.currentSession().createSQLQuery(query.toString());
        return insertOrUpdateQuery.executeUpdate();
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public Long redriverCount() {
        return (Long)this.currentSession().createQuery("select count(*) from ScheduledMessage").iterate().next();
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public List<ScheduledMessage> retrieveOldest(int offset, int rowCount) {
        return this.currentSession().createCriteria(ScheduledMessage.class).addOrder(Order.asc((String)"scheduledTime")).add((Criterion)Restrictions.lt((String)"scheduledTime", (Object)System.currentTimeMillis())).setFirstResult(offset).setMaxResults(rowCount).list();
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public int deleteInBatch(List<SmIdAndTaskIdWithExecutionVersion> messageIdsToDelete) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("delete from ScheduledMessage where (stateMachineId,taskId, executionVersion) in (");
        messageIdsToDelete.forEach(smIdAndTaskIdPairWithExecutionVersion -> queryBuilder.append("('").append(smIdAndTaskIdPairWithExecutionVersion.getSmId()).append("','").append(smIdAndTaskIdPairWithExecutionVersion.getTaskId()).append("','").append(smIdAndTaskIdPairWithExecutionVersion.getExecutionVersion()).append("'),"));
        queryBuilder.setCharAt(queryBuilder.length() - 1, ')');
        Query deleteQuery = this.currentSession().createQuery(queryBuilder.toString());
        return deleteQuery.executeUpdate();
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public void delete(SmIdAndTaskIdWithExecutionVersion smIdAndTaskIdWithExecutionVersion) {
        Query query = this.currentSession().createQuery("delete from ScheduledMessage where stateMachineId = :smId and taskId = :taskId and executionVersion = :executionVersion");
        query.setString("smId", smIdAndTaskIdWithExecutionVersion.getSmId());
        query.setLong("taskId", smIdAndTaskIdWithExecutionVersion.getTaskId().longValue());
        query.setLong("executionVersion", smIdAndTaskIdWithExecutionVersion.getExecutionVersion().longValue());
        query.executeUpdate();
    }

    private Session currentSession() {
        return this.sessionFactoryContext.getThreadLocalSession();
    }
}

