/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.task.AkkaTaskSupervisor;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;

public class AkkaGatewayTask
extends UntypedActor {
    private LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private static final AtomicLong INSTANCE_COUNTER = new AtomicLong();
    @Inject
    private static FluxRuntimeConnector fluxRuntimeConnector;

    public void onReceive(Object message) throws Exception {
        if (TaskAndEvents.class.isAssignableFrom(message.getClass())) {
            TaskAndEvents taskAndEvent = (TaskAndEvents)message;
            Props supervisorProps = AkkaTaskSupervisor.getTaskSupervisorProps(taskAndEvent.getTaskIdentifier(), taskAndEvent.getRetryCount());
            String supName = String.valueOf(taskAndEvent.getTaskName()) + "-Supervisor-" + INSTANCE_COUNTER.incrementAndGet();
            ActorRef sup = this.getContext().actorOf(supervisorProps, supName);
            sup.tell((Object)taskAndEvent, this.getSelf());
        } else if (Event.class.isAssignableFrom(message.getClass())) {
            Event returnedEvent = (Event)message;
            this.getContext().stop(this.getSender());
            fluxRuntimeConnector.submitEvent(new EventData(returnedEvent.getName(), returnedEvent.getType(), returnedEvent.getEventData(), returnedEvent.getEventSource()), returnedEvent.getStateMachineInstanceId());
        } else {
            this.logger.error("Task received a message that it cannot process. Only com.flipkart.flux.impl.message.TaskAndEvents is supported. Message type received is : {}", (Object)message.getClass().getName());
            this.unhandled(message);
        }
    }
}

