/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task.registry;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.OneForOneStrategy;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.cluster.routing.ClusterRouterPool;
import akka.cluster.routing.ClusterRouterPoolSettings;
import akka.cluster.singleton.ClusterSingletonManager;
import akka.cluster.singleton.ClusterSingletonManagerSettings;
import akka.cluster.singleton.ClusterSingletonProxy;
import akka.cluster.singleton.ClusterSingletonProxySettings;
import akka.remote.routing.RemoteRouterConfig;
import akka.routing.Pool;
import akka.routing.RoundRobinPool;
import com.flipkart.flux.domain.FluxError;
import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.impl.task.AkkaGatewayTask;
import com.flipkart.flux.impl.task.registry.ClusterListener;
import com.flipkart.flux.impl.task.registry.RouterConfigurationRegistry;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.polyguice.core.Initializable;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.util.Pair;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

@Singleton
public class EagerInitRouterRegistryImpl
implements RouterRegistry,
Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EagerInitRouterRegistryImpl.class);
    private ActorSystemManager actorSystemManager;
    private RouterConfigurationRegistry routerConfigurationRegistry;
    private final HashMap<String, ActorRef> proxyMap;
    private List<Address> memberAddresses = new CopyOnWriteArrayList<Address>();
    private int maxGatewayActorCreateRetries;

    @Inject
    public EagerInitRouterRegistryImpl(ActorSystemManager actorSystemManager, RouterConfigurationRegistry routerConfigurationRegistry, @Named(value="runtime.actorsystem.maxGatewayActorCreateRetries") int maxGatewayActorCreateRetries) {
        this.proxyMap = new HashMap();
        this.actorSystemManager = actorSystemManager;
        this.routerConfigurationRegistry = routerConfigurationRegistry;
        this.maxGatewayActorCreateRetries = maxGatewayActorCreateRetries;
    }

    @Override
    public ActorRef getRouter(String forWorker) {
        return this.proxyMap.get(forWorker);
    }

    public void initialize() {
        ActorSystem actorSystem = this.actorSystemManager.retrieveActorSystem();
        ClusterSingletonManagerSettings settings = ClusterSingletonManagerSettings.create((ActorSystem)actorSystem);
        actorSystem.actorOf(Props.create(ClusterListener.class, (Object[])new Object[]{this.memberAddresses}), "clusterListener");
        while (this.memberAddresses.isEmpty()) {
            LOGGER.info("Router init waiting 1000ms for cluster members to join...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new FluxError(FluxError.ErrorType.runtime, "All Router(s) initialization failed.", (Throwable)e);
            }
        }
        Iterable<Pair<String, ClusterRouterPoolSettings>> configurations = this.routerConfigurationRegistry.getConfigurations();
        for (Pair<String, ClusterRouterPoolSettings> next : configurations) {
            actorSystem.actorOf(ClusterSingletonManager.props((Props)new ClusterRouterPool((Pool)new RoundRobinPool(2).withSupervisorStrategy(this.getGatewayTasksuperviseStrategy()), (ClusterRouterPoolSettings)next.getValue()).props(new RemoteRouterConfig((Pool)new RoundRobinPool(6), this.memberAddresses).props(Props.create(AkkaGatewayTask.class, (Object[])new Object[0]))), (Object)PoisonPill.getInstance(), (ClusterSingletonManagerSettings)settings), (String)next.getKey());
            ClusterSingletonProxySettings proxySettings = ClusterSingletonProxySettings.create((ActorSystem)actorSystem);
            this.proxyMap.put((String)next.getKey(), actorSystem.actorOf(ClusterSingletonProxy.props((String)("/user/" + (String)next.getKey()), (ClusterSingletonProxySettings)proxySettings), String.valueOf((String)next.getKey()) + "_routerProxy"));
        }
    }

    private SupervisorStrategy getGatewayTasksuperviseStrategy() {
        return new OneForOneStrategy(this.maxGatewayActorCreateRetries, (Duration)Duration.Inf(), t -> {
            if (t instanceof FluxError) {
                FluxError fe = (FluxError)t;
                if (fe.getType().equals((Object)FluxError.ErrorType.timeout)) {
                    return SupervisorStrategy.resume();
                }
                return SupervisorStrategy.restart();
            }
            if (t instanceof RuntimeException) {
                return SupervisorStrategy.restart();
            }
            return SupervisorStrategy.escalate();
        });
    }
}

