/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.routing.ActorRefRoutee;
import akka.routing.Routee;
import akka.routing.Router;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.FluxError;
import com.flipkart.flux.impl.message.HookAndEvents;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.task.AbstractHook;
import com.flipkart.flux.impl.task.AbstractTask;
import com.flipkart.flux.impl.task.AkkaHook;
import com.flipkart.flux.impl.task.HookExecutor;
import com.flipkart.flux.impl.task.TaskExecutor;
import com.flipkart.flux.impl.task.TaskRegistry;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class AkkaTask
extends UntypedActor {
    private LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    @Inject
    private static TaskRegistry taskRegistry;
    @Inject
    @Named(value="HookRouter")
    private Router hookRouter;
    private static final ObjectMapper objectMapper;

    public void preRestart(Throwable reason, Option<Object> message) {
        this.getContext().system().scheduler().scheduleOnce(FiniteDuration.create((long)1L, (TimeUnit)TimeUnit.SECONDS), this.getSelf(), message.get(), (ExecutionContext)this.getContext().system().dispatcher(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onReceive(Object message) throws Exception {
        if (TaskAndEvents.class.isAssignableFrom(message.getClass())) {
            TaskAndEvents taskAndEvent = (TaskAndEvents)message;
            this.logger.debug("Received directive {}", (Object)taskAndEvent);
            AbstractTask task = taskRegistry.retrieveTask(taskAndEvent.getTaskIdentifier());
            if (task == null) {
                this.logger.error("Task received EventS that it cannot process. Events received are : {}", (Object)TaskRegistry.getEventsKey(taskAndEvent.getEvents()));
                return;
            }
            this.executeHooks(taskRegistry.getPreExecHooks(task), taskAndEvent.getEvents());
            String outputEventName = this.getOutputEventName(taskAndEvent);
            TaskExecutor taskExecutor = new TaskExecutor(task, taskAndEvent.getEvents(), taskAndEvent.getStateMachineId(), outputEventName);
            Event outputEvent = null;
            try {
                outputEvent = (Event)taskExecutor.execute();
            }
            catch (HystrixRuntimeException hre) {
                if (taskExecutor.isResponseTimedOut()) {
                    throw new FluxError(FluxError.ErrorType.timeout, "Execution timeout for : " + task.getName(), null, false);
                }
            }
            finally {
                if (outputEvent != null) {
                    this.getSender().tell((Object)outputEvent, this.getContext().parent());
                }
            }
            this.executeHooks(taskRegistry.getPostExecHooks(task), taskAndEvent.getEvents());
            return;
        }
        if (HookExecutor.STATUS.class.isAssignableFrom(message.getClass())) {
            return;
        }
        if (message instanceof Terminated) {
            this.hookRouter = this.hookRouter.removeRoutee(((Terminated)message).actor());
            ActorRef r = this.getContext().actorOf(Props.create(AkkaHook.class, (Object[])new Object[0]));
            this.getContext().watch(r);
            this.hookRouter = this.hookRouter.addRoutee((Routee)new ActorRefRoutee(r));
            return;
        }
        this.logger.error("Task received a message that it cannot process. Only com.flipkart.flux.impl.message.TaskAndEvents is supported. Message type received is : {}", (Object)message.getClass().getName());
        this.unhandled(message);
    }

    private void executeHooks(List<AbstractHook> hooks, Event[] events) {
        if (hooks != null) {
            for (AbstractHook hook : hooks) {
                HookAndEvents hookAndEvents = new HookAndEvents(hook, events);
                this.hookRouter.route((Object)hookAndEvents, this.getSelf());
            }
        }
    }

    private String getOutputEventName(TaskAndEvents taskAndEvent) throws IOException {
        String outputEvent = taskAndEvent.getOutputEvent();
        return outputEvent != null ? ((EventDefinition)objectMapper.readValue(outputEvent, EventDefinition.class)).getName() : null;
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

