/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.pattern.Backoff;
import akka.pattern.BackoffOptions;
import akka.pattern.BackoffSupervisor;
import com.flipkart.flux.domain.FluxError;
import com.flipkart.flux.impl.task.AkkaTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class AkkaTaskSupervisor {
    private static final AtomicLong INSTANCE_COUNTER = new AtomicLong();
    private static final FiniteDuration MIN_BACKOFF = FiniteDuration.create((long)2L, (TimeUnit)TimeUnit.SECONDS);
    private static final FiniteDuration MAX_BACKOFF = FiniteDuration.create((long)600L, (TimeUnit)TimeUnit.SECONDS);
    private static final Logger LOGGER = LoggerFactory.getLogger(AkkaTaskSupervisor.class);

    public static Props getTaskSupervisorProps(String taskActorName, long maxRetries) {
        Props childProps = Props.create(AkkaTask.class, (Object[])new Object[0]);
        Props supervisorProps = BackoffSupervisor.props((BackoffOptions)Backoff.onStop((Props)childProps, (String)(taskActorName + "-" + INSTANCE_COUNTER.incrementAndGet()), (FiniteDuration)MIN_BACKOFF, (FiniteDuration)MAX_BACKOFF, (double)0.2).withSupervisorStrategy(new OneForOneStrategy((int)maxRetries, (Duration)Duration.Inf(), t -> {
            if (t instanceof FluxError) {
                FluxError fe = (FluxError)t;
                if (fe.getType().equals((Object)FluxError.ErrorType.timeout)) {
                    LOGGER.info("Retrying execution of Task. Cause - " + fe.getMessage());
                    return SupervisorStrategy.restart();
                }
                return SupervisorStrategy.stop();
            }
            if (t instanceof RuntimeException) {
                return SupervisorStrategy.stop();
            }
            return SupervisorStrategy.escalate();
        })));
        return supervisorProps;
    }
}

