/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.boot;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.DeadLetter;
import akka.actor.Props;
import com.flipkart.flux.impl.recovery.DeadLetterActor;
import com.flipkart.polyguice.core.Disposable;
import com.flipkart.polyguice.core.Initializable;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kamon.Kamon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

@Singleton
public class ActorSystemManager
implements Disposable,
Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActorSystemManager.class);
    private String actorSystemName;
    private String configName;
    private Boolean withMetrics;
    private ActorSystem system;
    private boolean isInitialised = false;

    ActorSystemManager() {
    }

    @Inject
    public ActorSystemManager(@Named(value="runtime.actorsystem.name") String actorSystemName, @Named(value="runtime.actorsystem.configname") String configName, @Named(value="runtime.actorsystem.metrics") Boolean withMetrics) {
        this();
        this.actorSystemName = actorSystemName;
        this.configName = configName;
        this.withMetrics = withMetrics;
    }

    public ActorSystem retrieveActorSystem() {
        if (this.isInitialised) {
            return this.system;
        }
        throw new IllegalStateException("Actor system not initialised yet");
    }

    public void initialize() {
        if (this.withMetrics.booleanValue()) {
            Kamon.start();
        }
        Config config = ConfigFactory.load((String)this.configName);
        this.system = ActorSystem.create((String)this.actorSystemName, (Config)config);
        ActorRef deadLetterActor = this.system.actorOf(Props.create(DeadLetterActor.class, (Object[])new Object[0]));
        this.system.eventStream().subscribe(deadLetterActor, DeadLetter.class);
        this.isInitialised = true;
    }

    public void dispose() {
        if (this.withMetrics.booleanValue()) {
            Kamon.shutdown();
        }
        if (this.system != null) {
            Future terminateFut = this.system.terminate();
            try {
                Await.result((Awaitable)terminateFut, (Duration)Duration.Inf());
            }
            catch (Exception e) {
                LOGGER.error("Error shutting down Actor system", (Throwable)e);
            }
        }
    }

    public boolean isInitialised() {
        return this.isInitialised;
    }
}

