/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.FluxError;
import com.flipkart.flux.impl.task.AbstractTask;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalJvmTask
extends AbstractTask {
    private final Executable toInvoke;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(LocalJvmTask.class);

    public LocalJvmTask(Executable toInvoke) {
        this.toInvoke = toInvoke;
    }

    @Override
    public String getName() {
        return this.toInvoke.getName();
    }

    @Override
    public String getTaskGroupName() {
        return "flux";
    }

    @Override
    public int getExecutionConcurrency() {
        return 10;
    }

    @Override
    public int getExecutionTimeout() {
        return (int)this.toInvoke.getTimeout();
    }

    public Pair<Object, FluxError> execute(Event[] events) {
        Object[] parameters = new Object[events.length];
        Class[] parameterTypes = this.toInvoke.getParameterTypes();
        try {
            for (int i = 0; i < parameterTypes.length; ++i) {
                for (Event anEvent : events) {
                    if (!Class.forName(anEvent.getType()).equals(parameterTypes[i])) continue;
                    parameters[i] = objectMapper.readValue(anEvent.getEventData(), Class.forName(anEvent.getType()));
                }
                if (parameters[i] != null) continue;
                logger.warn("Could not find a paramter of type {} in event list {}", (Object)parameterTypes[i], (Object)events);
                throw new RuntimeException("Could not find a paramter of type " + parameterTypes[i]);
            }
            Object returnObject = this.toInvoke.execute(parameters);
            return new Pair(returnObject, null);
        }
        catch (Exception e) {
            logger.warn("Bad things happened while trying to execute {}", (Object)this.toInvoke, (Object)e);
            return new Pair(null, (Object)new FluxError(FluxError.ErrorType.runtime, e.getMessage(), (Throwable)e));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalJvmTask that = (LocalJvmTask)o;
        return this.toInvoke.equals(that.toInvoke);
    }

    public int hashCode() {
        return this.toInvoke.hashCode();
    }
}

