/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import com.flipkart.flux.client.intercept.UnknownIdentifierException;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.client.registry.ExecutableImpl;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.flipkart.flux.impl.task.LocalJvmTask;
import com.flipkart.flux.impl.task.TaskRegistry;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskRegistryTest {
    @Mock
    ExecutableRegistry executableRegistry;
    private TaskRegistry taskRegistry;

    @Before
    public void setUp() throws Exception {
        this.taskRegistry = new TaskRegistry(this.executableRegistry);
    }

    @Test
    public void testRetrieve_shouldReturnTaskGivenIdentifier() throws Exception {
        Object someObject = new Object();
        ExecutableImpl givenExecutable = new ExecutableImpl(someObject, someObject.getClass().getDeclaredMethod("toString", new Class[0]), 10L);
        Mockito.when((Object)this.executableRegistry.getTask(Matchers.anyString())).thenReturn((Object)givenExecutable);
        Assertions.assertThat((Object)this.taskRegistry.retrieveTask("com.flipkart.flux.impl.SomeWorkflow_simpleStringModifyingTask_java.lang.String_java.lang.String")).isEqualTo((Object)new LocalJvmTask((Executable)givenExecutable));
        ((ExecutableRegistry)Mockito.verify((Object)this.executableRegistry, (VerificationMode)Mockito.times((int)1))).getTask("com.flipkart.flux.impl.SomeWorkflow_simpleStringModifyingTask_java.lang.String_java.lang.String");
    }

    @Test(expected=UnknownIdentifierException.class)
    public void testRetrieve_shouldBombIfTaskCannotBeFound() throws Exception {
        Mockito.when((Object)this.executableRegistry.getTask(Matchers.anyString())).thenThrow(new Throwable[]{new UnknownIdentifierException("blah")});
        this.taskRegistry.retrieveTask("com.flipkart.flux.impl.SomeWorkflow_simpleStringModifyingTask_java.lang.String_java.lang.String");
    }
}

